/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.executionlog.applib.dom;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.causeway.applib.exceptions.RecoverableException;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.iactn.Execution;
import org.apache.causeway.extensions.executionlog.applib.dom.ExecutionLogEntry;
import org.jspecify.annotations.Nullable;

public interface ExecutionLogEntryRepository {
    public ExecutionLogEntry createEntryAndPersist(Execution var1);

    public List<ExecutionLogEntry> findByInteractionId(UUID var1);

    public Optional<ExecutionLogEntry> findByInteractionIdAndSequence(UUID var1, int var2);

    public List<ExecutionLogEntry> findByFromAndTo(@Nullable LocalDate var1, @Nullable LocalDate var2);

    public List<ExecutionLogEntry> findMostRecent();

    public List<ExecutionLogEntry> findMostRecent(int var1);

    public List<ExecutionLogEntry> findByTarget(Bookmark var1);

    public List<ExecutionLogEntry> findByTargetAndTimestampAfter(Bookmark var1, Timestamp var2);

    public List<ExecutionLogEntry> findByTargetAndTimestampBefore(Bookmark var1, Timestamp var2);

    public List<ExecutionLogEntry> findByTargetAndTimestampBetween(Bookmark var1, Timestamp var2, Timestamp var3);

    public List<ExecutionLogEntry> findByTimestampAfter(Timestamp var1);

    public List<ExecutionLogEntry> findByTimestampBefore(Timestamp var1);

    public List<ExecutionLogEntry> findByTimestampBetween(Timestamp var1, Timestamp var2);

    public List<ExecutionLogEntry> findRecentByUsername(String var1);

    public List<ExecutionLogEntry> findRecentByTarget(Bookmark var1);

    public List<ExecutionLogEntry> findAll();

    public void removeAll();

    public static class NotFoundException
    extends RecoverableException {
        private static final long serialVersionUID = 1L;
        private final UUID interactionId;

        public NotFoundException(UUID interactionId) {
            super("Execution log entry not found");
            this.interactionId = interactionId;
        }

        @Generated
        public UUID getInteractionId() {
            return this.interactionId;
        }
    }
}

