/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.executionlog.applib.dom;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.causeway.applib.query.NamedQuery;
import org.apache.causeway.applib.query.Query;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.factory.FactoryService;
import org.apache.causeway.applib.services.iactn.Execution;
import org.apache.causeway.applib.services.repository.RepositoryService;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.config.environment.CausewaySystemEnvironment;
import org.apache.causeway.extensions.executionlog.applib.dom.ExecutionLogEntry;
import org.apache.causeway.extensions.executionlog.applib.dom.ExecutionLogEntryRepository;
import org.jspecify.annotations.Nullable;

public abstract class ExecutionLogEntryRepositoryAbstract<E extends ExecutionLogEntry>
implements ExecutionLogEntryRepository {
    private final Class<E> executionLogEntryClass;
    @Inject
    Provider<RepositoryService> repositoryServiceProvider;
    @Inject
    FactoryService factoryService;
    @Inject
    CausewaySystemEnvironment causewaySystemEnvironment;

    protected ExecutionLogEntryRepositoryAbstract(Class<E> executionLogEntryClass) {
        this.executionLogEntryClass = executionLogEntryClass;
    }

    public Class<E> getEntityClass() {
        return this.executionLogEntryClass;
    }

    protected ExecutionLogEntryRepositoryAbstract(Class<E> executionLogEntryClass, Provider<RepositoryService> repositoryServiceProvider, FactoryService factoryService) {
        this.executionLogEntryClass = executionLogEntryClass;
        this.repositoryServiceProvider = repositoryServiceProvider;
        this.factoryService = factoryService;
    }

    public E createEntryAndPersist(Execution execution) {
        ExecutionLogEntry e = (ExecutionLogEntry)this.factoryService.detachedEntity(this.executionLogEntryClass);
        e.init(execution);
        this.persist(e);
        return (E)e;
    }

    @Override
    public List<ExecutionLogEntry> findByInteractionId(UUID interactionId) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findByInteractionId").withParameter("interactionId", (Object)interactionId)));
    }

    @Override
    public Optional<ExecutionLogEntry> findByInteractionIdAndSequence(UUID interactionId, int sequence) {
        return (Optional)_Casts.uncheckedCast((Object)this.repositoryService().firstMatch((Query)Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findByInteractionIdAndSequence").withParameter("interactionId", (Object)interactionId).withParameter("sequence", (Object)sequence)));
    }

    @Override
    public List<ExecutionLogEntry> findByFromAndTo(@Nullable LocalDate from, @Nullable LocalDate to) {
        Timestamp fromTs = ExecutionLogEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(from, 0);
        Timestamp toTs = ExecutionLogEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(to, 1);
        NamedQuery query = from != null ? (to != null ? Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findByTimestampBetween").withParameter("from", (Object)fromTs).withParameter("to", (Object)toTs) : Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findByTimestampAfter").withParameter("from", (Object)fromTs)) : (to != null ? Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findByTimestampBefore").withParameter("to", (Object)toTs) : Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.find"));
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)query));
    }

    @Override
    public List<ExecutionLogEntry> findMostRecent() {
        return this.findMostRecent(100);
    }

    @Override
    public List<ExecutionLogEntry> findMostRecent(int limit) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches(Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findMostRecent").withLimit((long)limit)));
    }

    @Override
    public List<ExecutionLogEntry> findByTarget(Bookmark target) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findByTarget").withParameter("target", (Object)target)));
    }

    @Override
    public List<ExecutionLogEntry> findByTargetAndTimestampAfter(Bookmark target, Timestamp timestamp) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findByTargetAndTimestampAfter").withParameter("target", (Object)target).withParameter("timestamp", (Object)timestamp)));
    }

    @Override
    public List<ExecutionLogEntry> findByTargetAndTimestampBefore(Bookmark target, Timestamp timestamp) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findByTargetAndTimestampBefore").withParameter("target", (Object)target).withParameter("timestamp", (Object)timestamp)));
    }

    @Override
    public List<ExecutionLogEntry> findByTargetAndTimestampBetween(Bookmark target, Timestamp timestampFrom, Timestamp timestampTo) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findByTargetAndTimestampBetween").withParameter("target", (Object)target).withParameter("timestampFrom", (Object)timestampFrom).withParameter("timestampTo", (Object)timestampTo)));
    }

    @Override
    public List<ExecutionLogEntry> findByTimestampAfter(Timestamp timestamp) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findByTimestampAfter").withParameter("from", (Object)timestamp)));
    }

    @Override
    public List<ExecutionLogEntry> findByTimestampBefore(Timestamp timestamp) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findByTimestampBefore").withParameter("to", (Object)timestamp)));
    }

    @Override
    public List<ExecutionLogEntry> findByTimestampBetween(Timestamp timestampFrom, Timestamp timestampTo) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findByTimestampBetween").withParameter("from", (Object)timestampFrom).withParameter("to", (Object)timestampTo)));
    }

    @Override
    public List<ExecutionLogEntry> findRecentByUsername(String username) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches(Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findRecentByUsername").withParameter("username", (Object)username).withLimit(30L)));
    }

    @Override
    public List<ExecutionLogEntry> findRecentByTarget(Bookmark target) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches(Query.named(this.executionLogEntryClass, (String)"causeway.ext.executionLog.ExecutionLogEntry.findRecentByTarget").withParameter("target", (Object)target).withLimit(30L)));
    }

    private void persist(E commandLogEntry) {
        this.repositoryService().persist(commandLogEntry);
    }

    private RepositoryService repositoryService() {
        return (RepositoryService)this.repositoryServiceProvider.get();
    }

    @Override
    public List<ExecutionLogEntry> findAll() {
        if (this.causewaySystemEnvironment.getDeploymentType().isProduction()) {
            throw new IllegalStateException("Cannot call 'findAll' in production systems");
        }
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allInstances(this.executionLogEntryClass));
    }

    @Override
    public void removeAll() {
        if (this.causewaySystemEnvironment.getDeploymentType().isProduction()) {
            throw new IllegalStateException("Cannot call 'removeAll' in production systems");
        }
        this.repositoryService().removeAll(this.executionLogEntryClass);
    }

    private static Timestamp toTimestampStartOfDayWithOffset(@Nullable LocalDate dt, int daysOffset) {
        return dt != null ? new Timestamp(Instant.from(dt.atStartOfDay().plusDays(daysOffset).atZone(ZoneId.systemDefault())).toEpochMilli()) : null;
    }
}

