/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.executionlog.applib.spiimpl;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import lombok.Generated;
import org.apache.causeway.applib.services.iactn.Execution;
import org.apache.causeway.applib.services.publishing.spi.ExecutionSubscriber;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.executionlog.applib.dom.ExecutionLogEntryRepository;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.ext.executionLog.ExecutionSubscriberForExecutionLog")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class ExecutionSubscriberForExecutionLog
implements ExecutionSubscriber {
    @Generated
    private static final Logger log = LogManager.getLogger(ExecutionSubscriberForExecutionLog.class);
    static final String LOGICAL_TYPE_NAME = "causeway.ext.executionLog.ExecutionSubscriberForExecutionLog";
    final ExecutionLogEntryRepository executionLogEntryRepository;
    final CausewayConfiguration causewayConfiguration;

    public boolean isEnabled() {
        return this.causewayConfiguration.getExtensions().getExecutionLog().getPersist().isEnabled();
    }

    public void onExecution(Execution<?, ?> execution) {
        if (!this.isEnabled()) {
            return;
        }
        this.executionLogEntryRepository.createEntryAndPersist(execution);
    }

    @Inject
    @Generated
    public ExecutionSubscriberForExecutionLog(ExecutionLogEntryRepository executionLogEntryRepository, CausewayConfiguration causewayConfiguration) {
        this.executionLogEntryRepository = executionLogEntryRepository;
        this.causewayConfiguration = causewayConfiguration;
    }
}

