/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.executionoutbox.jpa.dom;

import jakarta.inject.Named;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Index;
import jakarta.persistence.Lob;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.sql.Timestamp;
import java.util.UUID;
import lombok.Generated;
import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.Editing;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.jaxb.PersistentEntityAdapter;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.extensions.executionoutbox.applib.dom.ExecutionOutboxEntry;
import org.apache.causeway.extensions.executionoutbox.applib.dom.ExecutionOutboxEntryType;
import org.apache.causeway.extensions.executionoutbox.jpa.dom.ExecutionOutboxEntryPK;
import org.apache.causeway.persistence.jpa.applib.integration.CausewayEntityListener;
import org.apache.causeway.persistence.jpa.integration.typeconverters.applib.CausewayBookmarkConverter;
import org.apache.causeway.persistence.jpa.integration.typeconverters.schema.v2.CausewayInteractionDtoConverter;
import org.apache.causeway.schema.ixn.v2.InteractionDto;

@Entity
@Table(schema="causewayExtExecutionOutbox", name="ExecutionOutboxEntry", indexes={@Index(name="ExecutionOutboxEntry__timestamp__IDX", columnList="timestamp"), @Index(name="ExecutionOutboxEntry__target__timestamp__IDX", columnList="target, timestamp"), @Index(name="ExecutionOutboxEntry__username__timestamp__IDX", columnList="username, timestamp")})
@NamedQueries(value={@NamedQuery(name="causeway.ext.executionOutbox.ExecutionOutboxEntry.findByInteractionIdAndSequence", query="SELECT ele   FROM ExecutionOutboxEntry ele  WHERE ele.pk.interactionId = :interactionId    AND ele.pk.sequence      = :sequence "), @NamedQuery(name="causeway.ext.executionOutbox.ExecutionOutboxEntry.findOldest", query="SELECT ele   FROM ExecutionOutboxEntry ele  ORDER BY ele.timestamp ASC, ele.pk.interactionId ASC, ele.pk.sequence DESC")})
@Named(value="causeway.ext.executionOutbox.ExecutionOutboxEntry")
@DomainObject(editing=Editing.DISABLED, entityChangePublishing=Publishing.DISABLED)
@XmlJavaTypeAdapter(value=PersistentEntityAdapter.class)
@EntityListeners(value={CausewayEntityListener.class})
public class ExecutionOutboxEntry
extends org.apache.causeway.extensions.executionoutbox.applib.dom.ExecutionOutboxEntry {
    @EmbeddedId
    ExecutionOutboxEntryPK pk;
    @Column(nullable=false, length=30)
    @Enumerated(value=EnumType.STRING)
    @ExecutionOutboxEntry.ExecutionType
    private ExecutionOutboxEntryType executionType;
    @Column(nullable=false, length=120)
    @ExecutionOutboxEntry.Username
    private String username;
    @Column(nullable=false)
    @ExecutionOutboxEntry.Timestamp
    private Timestamp timestamp;
    @Convert(converter=CausewayBookmarkConverter.class)
    @Column(nullable=true, length=1500)
    @ExecutionOutboxEntry.Target
    private Bookmark target;
    @Column(nullable=false, length=255)
    @ExecutionOutboxEntry.LogicalMemberIdentifier
    private String logicalMemberIdentifier;
    @Convert(converter=CausewayInteractionDtoConverter.class)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(nullable=false, columnDefinition="CLOB")
    @ExecutionOutboxEntry.InteractionDtoAnnot
    private InteractionDto interactionDto;
    @Column(nullable=true)
    @ExecutionOutboxEntry.StartedAt
    private Timestamp startedAt;
    @Column(nullable=true)
    @ExecutionOutboxEntry.CompletedAt
    private Timestamp completedAt;

    @Transient
    @ExecutionOutboxEntry.InteractionId
    public UUID getInteractionId() {
        return this.pk != null ? this.pk.getInteractionId() : null;
    }

    @Transient
    public void setInteractionId(UUID interactionId) {
        this.pk = new ExecutionOutboxEntryPK(interactionId, this.getSequence());
    }

    @Transient
    @ExecutionOutboxEntry.Sequence
    public int getSequence() {
        return this.pk != null ? this.pk.getSequence() : 0;
    }

    @Transient
    public void setSequence(int sequence) {
        this.pk = new ExecutionOutboxEntryPK(this.getInteractionId(), sequence);
    }

    public void setLogicalMemberIdentifier(String logicalMemberIdentifier) {
        this.logicalMemberIdentifier = ExecutionOutboxEntry.Util.abbreviated((String)logicalMemberIdentifier, (int)255);
    }

    @Generated
    public ExecutionOutboxEntryType getExecutionType() {
        return this.executionType;
    }

    @Generated
    public void setExecutionType(ExecutionOutboxEntryType executionType) {
        this.executionType = executionType;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public Bookmark getTarget() {
        return this.target;
    }

    @Generated
    public void setTarget(Bookmark target) {
        this.target = target;
    }

    @Generated
    public String getLogicalMemberIdentifier() {
        return this.logicalMemberIdentifier;
    }

    @Generated
    public InteractionDto getInteractionDto() {
        return this.interactionDto;
    }

    @Generated
    public void setInteractionDto(InteractionDto interactionDto) {
        this.interactionDto = interactionDto;
    }

    @Generated
    public Timestamp getStartedAt() {
        return this.startedAt;
    }

    @Generated
    public void setStartedAt(Timestamp startedAt) {
        this.startedAt = startedAt;
    }

    @Generated
    public Timestamp getCompletedAt() {
        return this.completedAt;
    }

    @Generated
    public void setCompletedAt(Timestamp completedAt) {
        this.completedAt = completedAt;
    }
}

