/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.executionoutbox.jpa.dom;

import jakarta.annotation.Priority;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Embeddable;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.UUID;
import lombok.Generated;
import org.apache.causeway.applib.value.semantics.ValueSemanticsBasedOnIdStringifierEntityAgnostic;
import org.apache.causeway.persistence.jpa.integration.typeconverters.java.util.JavaUtilUuidConverter;
import org.jspecify.annotations.NonNull;
import org.springframework.stereotype.Component;

@Embeddable
public class ExecutionOutboxEntryPK
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = "_";
    @Convert(converter=JavaUtilUuidConverter.class)
    @Column(name="interactionId", nullable=false, length=36)
    private UUID interactionId;
    @Column(name="sequence", nullable=false)
    public int sequence;

    public ExecutionOutboxEntryPK(String value) {
        StringTokenizer token = new StringTokenizer(value, SEPARATOR);
        this.interactionId = UUID.fromString(token.nextToken());
        this.sequence = Integer.parseInt(token.nextToken());
    }

    public String toString() {
        return String.valueOf(this.interactionId) + SEPARATOR + this.sequence;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionOutboxEntryPK)) {
            return false;
        }
        ExecutionOutboxEntryPK other = (ExecutionOutboxEntryPK)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSequence() != other.getSequence()) {
            return false;
        }
        UUID this$interactionId = this.getInteractionId();
        UUID other$interactionId = other.getInteractionId();
        return !(this$interactionId == null ? other$interactionId != null : !((Object)this$interactionId).equals(other$interactionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionOutboxEntryPK;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSequence();
        UUID $interactionId = this.getInteractionId();
        result = result * 59 + ($interactionId == null ? 43 : ((Object)$interactionId).hashCode());
        return result;
    }

    @Generated
    public ExecutionOutboxEntryPK() {
    }

    @Generated
    public ExecutionOutboxEntryPK(UUID interactionId, int sequence) {
        this.interactionId = interactionId;
        this.sequence = sequence;
    }

    @Generated
    UUID getInteractionId() {
        return this.interactionId;
    }

    @Generated
    int getSequence() {
        return this.sequence;
    }

    @Component
    @Priority(value=0x3FFFFFFF)
    public static class Semantics
    extends ValueSemanticsBasedOnIdStringifierEntityAgnostic<ExecutionOutboxEntryPK> {
        public Semantics() {
            super(ExecutionOutboxEntryPK.class);
        }

        public String enstring(ExecutionOutboxEntryPK value) {
            return value.toString();
        }

        public ExecutionOutboxEntryPK destring(@NonNull String stringified) {
            return new ExecutionOutboxEntryPK(stringified);
        }

        public boolean isValid(@NonNull ExecutionOutboxEntryPK value) {
            return value.getInteractionId() != null;
        }
    }
}

