/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.fullcalendar.applib.value;

import jakarta.inject.Named;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Value;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.extensions.fullcalendar.applib.value.CalendarEventSemantics;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Named(value="causeway.ext.fullcalendar.value.CalendarEvent")
@Value
@XmlJavaTypeAdapter(value=JaxbAdapter.class)
public class CalendarEvent
implements Comparable<CalendarEvent>,
Serializable {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.fullcalendar.value.CalendarEvent";
    private static final long serialVersionUID = 1L;
    private final long epochMillis;
    private final @NonNull String calendarName;
    private final @NonNull String title;
    private final @Nullable String notes;

    public static CalendarEvent of(@NonNull ZonedDateTime dateTime, @NonNull String calendarName, @NonNull String title) {
        return CalendarEvent.of(dateTime, calendarName, title, null);
    }

    public static CalendarEvent of(@NonNull ZonedDateTime dateTime, @NonNull String calendarName, @NonNull String title, @Nullable String notes) {
        return new CalendarEvent(dateTime.toInstant().toEpochMilli(), calendarName, title, notes);
    }

    public CalendarEvent withDateTime(@NonNull ZonedDateTime dateTime) {
        return new CalendarEvent(dateTime.toInstant().toEpochMilli(), this.calendarName, this.title, this.notes);
    }

    public CalendarEvent withDateTime(@NonNull LocalDateTime localDateTime, @NonNull ZoneId zoneId) {
        return this.withDateTime(ZonedDateTime.of(localDateTime, zoneId));
    }

    public ZonedDateTime asDateTime(@NonNull ZoneId zoneId) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.epochMillis), zoneId);
    }

    @Override
    public int compareTo(CalendarEvent other) {
        return Long.compare(this.epochMillis, other.getEpochMillis());
    }

    @Generated
    public long getEpochMillis() {
        return this.epochMillis;
    }

    @Generated
    public @NonNull String getCalendarName() {
        return this.calendarName;
    }

    @Generated
    public @NonNull String getTitle() {
        return this.title;
    }

    @Generated
    public @Nullable String getNotes() {
        return this.notes;
    }

    @Generated
    public CalendarEvent withEpochMillis(long epochMillis) {
        return this.epochMillis == epochMillis ? this : new CalendarEvent(epochMillis, this.calendarName, this.title, this.notes);
    }

    @Generated
    public CalendarEvent withCalendarName(@NonNull String calendarName) {
        if (calendarName == null) {
            throw new NullPointerException("calendarName is marked non-null but is null");
        }
        return this.calendarName == calendarName ? this : new CalendarEvent(this.epochMillis, calendarName, this.title, this.notes);
    }

    @Generated
    public CalendarEvent withTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        return this.title == title ? this : new CalendarEvent(this.epochMillis, this.calendarName, title, this.notes);
    }

    @Generated
    public CalendarEvent withNotes(@Nullable String notes) {
        return this.notes == notes ? this : new CalendarEvent(this.epochMillis, this.calendarName, this.title, notes);
    }

    @Generated
    public String toString() {
        return "CalendarEvent(epochMillis=" + this.getEpochMillis() + ", calendarName=" + this.getCalendarName() + ", title=" + this.getTitle() + ", notes=" + this.getNotes() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalendarEvent)) {
            return false;
        }
        CalendarEvent other = (CalendarEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpochMillis() != other.getEpochMillis()) {
            return false;
        }
        String this$calendarName = this.getCalendarName();
        String other$calendarName = other.getCalendarName();
        if (this$calendarName == null ? other$calendarName != null : !this$calendarName.equals(other$calendarName)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        return !(this$notes == null ? other$notes != null : !this$notes.equals(other$notes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalendarEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $epochMillis = this.getEpochMillis();
        result = result * 59 + (int)($epochMillis >>> 32 ^ $epochMillis);
        String $calendarName = this.getCalendarName();
        result = result * 59 + ($calendarName == null ? 43 : $calendarName.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        return result;
    }

    @Generated
    public CalendarEvent(long epochMillis, @NonNull String calendarName, @NonNull String title, @Nullable String notes) {
        if (calendarName == null) {
            throw new NullPointerException("calendarName is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.epochMillis = epochMillis;
        this.calendarName = calendarName;
        this.title = title;
        this.notes = notes;
    }

    public static final class JaxbAdapter
    extends XmlAdapter<ValueDecomposition, CalendarEvent> {
        public CalendarEvent unmarshal(ValueDecomposition dto) {
            return dto != null ? new CalendarEventSemantics().compose(dto) : null;
        }

        public ValueDecomposition marshal(CalendarEvent v) {
            return v != null ? new CalendarEventSemantics().decompose(v) : null;
        }
    }
}

