/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.fullcalendar.applib.value;

import jakarta.inject.Inject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.applib.annotation.Parameter;
import org.apache.causeway.applib.annotation.ParameterLayout;
import org.apache.causeway.applib.annotation.PrecedingParamsPolicy;
import org.apache.causeway.applib.annotation.PromptStyle;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.util.schema.CommonDtoUtils;
import org.apache.causeway.applib.value.semantics.DefaultsProvider;
import org.apache.causeway.applib.value.semantics.Renderer;
import org.apache.causeway.applib.value.semantics.TemporalValueSemantics;
import org.apache.causeway.applib.value.semantics.ValueDecomposition;
import org.apache.causeway.applib.value.semantics.ValueSemanticsAbstract;
import org.apache.causeway.applib.value.semantics.ValueSemanticsProvider;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._StringInterpolation;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.io.TextUtils;
import org.apache.causeway.extensions.fullcalendar.applib.value.CalendarEvent;
import org.apache.causeway.schema.common.v2.TypedTupleDto;
import org.apache.causeway.schema.common.v2.ValueType;
import org.jspecify.annotations.NonNull;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;

@Component
@Import(value={CalendarEvent_default.class})
public class CalendarEventSemantics
extends ValueSemanticsAbstract<CalendarEvent>
implements DefaultsProvider<CalendarEvent>,
Renderer<CalendarEvent> {
    @Inject
    private TemporalValueSemantics<ZonedDateTime> zonedDateTimeValueSemantics;
    private final String titleTemplate = "[${calendar-name}] ${title} @ ${timestamp}";
    private final Can<String> htmlTemplate = (Can)TextUtils.readLinesFromResource(((Object)((Object)this)).getClass(), (String)"CalendarEvent.html", (Charset)StandardCharsets.UTF_8).stream().skip(20L).collect(Can.toCan());

    public Class<CalendarEvent> getCorrespondingClass() {
        return CalendarEvent.class;
    }

    public ValueType getSchemaValueType() {
        return ValueType.COMPOSITE;
    }

    public CalendarEvent getDefaultValue() {
        return new CalendarEvent(Instant.now().toEpochMilli(), "Default Calendar", "New Event", "empty");
    }

    public ValueDecomposition decompose(CalendarEvent value) {
        return CommonDtoUtils.typedTupleBuilder((Object)value).addFundamentalType(ValueType.LONG, "epochMillis", CalendarEvent::getEpochMillis).addFundamentalType(ValueType.STRING, "calendarName", CalendarEvent::getCalendarName).addFundamentalType(ValueType.STRING, "title", CalendarEvent::getTitle).addFundamentalType(ValueType.STRING, "notes", CalendarEvent::getNotes).buildAsDecomposition();
    }

    public CalendarEvent compose(ValueDecomposition decomposition) {
        TypedTupleDto dto = decomposition.composite();
        Map elementMap = CommonDtoUtils.typedTupleAsMap((TypedTupleDto)dto);
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli((Long)elementMap.get("epochMillis")), ZoneId.systemDefault());
        String calendarName = (String)elementMap.get("calendarName");
        String title = (String)elementMap.get("title");
        String notes = (String)elementMap.get("notes");
        return CalendarEvent.of(dateTime, calendarName, title, notes);
    }

    public String titlePresentation(ValueSemanticsProvider.Context context, CalendarEvent value) {
        return this.renderTitle(value, v -> {
            String title = new _StringInterpolation(this.toMap(context, value)).applyTo("[${calendar-name}] ${title} @ ${timestamp}");
            return title;
        });
    }

    public String htmlPresentation(ValueSemanticsProvider.Context context, CalendarEvent value) {
        return this.renderHtml(value, v -> {
            String html = new _StringInterpolation(this.toMapHtmlEscaped(context, value)).applyTo(this.htmlTemplate).stream().collect(Collectors.joining());
            return html;
        });
    }

    private Map<String, @NonNull String> toMap(ValueSemanticsProvider.Context context, CalendarEvent v) {
        return Map.of("title", v.getTitle(), "calendar-name", v.getCalendarName(), "timestamp", this.zonedDateTimeValueSemantics.htmlPresentation(context, (Object)v.asDateTime(context.interactionContext().getTimeZone())), "notes", _Strings.nullToEmpty((String)v.getNotes()));
    }

    private Map<String, @NonNull String> toMapHtmlEscaped(ValueSemanticsProvider.Context context, CalendarEvent v) {
        return Map.of("title", _Strings.htmlEscape((String)v.getTitle()), "calendar-name", _Strings.htmlEscape((String)v.getCalendarName()), "timestamp", this.zonedDateTimeValueSemantics.htmlPresentation(context, (Object)v.asDateTime(context.interactionContext().getTimeZone())), "notes", _Strings.htmlEscape((String)_Strings.nullToEmpty((String)v.getNotes())));
    }

    public Can<CalendarEvent> getExamples() {
        CalendarEvent a = CalendarEvent.of(ZonedDateTime.of(2022, 5, 13, 17, 30, 15, 0, ZoneOffset.ofHours(3)), "Business", "Weekly Meetup", "Calendar Notes: <a href=\"https://apache.org\">apache.org</a>");
        CalendarEvent b = CalendarEvent.of(ZonedDateTime.of(2022, 6, 14, 18, 31, 16, 0, ZoneOffset.ofHours(4)), "Private", "Dentist Appointment", "Calendar Notes");
        CalendarEvent c = CalendarEvent.of(ZonedDateTime.of(2022, 7, 15, 19, 32, 17, 0, ZoneOffset.ofHours(5)), "Family and Friends", "Birthday Party");
        return Can.of((Object[])new CalendarEvent[]{a, b, c});
    }

    @Action(commandPublishing=Publishing.DISABLED, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.SAFE)
    @ActionLayout(promptStyle=PromptStyle.INLINE_AS_IF_EDIT)
    public static class CalendarEvent_default {
        private final CalendarEvent mixee;

        @MemberSupport
        public CalendarEvent act(@Parameter LocalDateTime dateTime, @Parameter(precedingParamsPolicy=PrecedingParamsPolicy.PRESERVE_CHANGES) String calendarName, @Parameter(precedingParamsPolicy=PrecedingParamsPolicy.PRESERVE_CHANGES) String title, @Parameter(optionality=Optionality.OPTIONAL, precedingParamsPolicy=PrecedingParamsPolicy.PRESERVE_CHANGES) @ParameterLayout(multiLine=4) String notes) {
            Parameters p = new Parameters(dateTime, calendarName, title, notes);
            return p.construct();
        }

        @MemberSupport
        public LocalDateTime defaultDateTime(Parameters p) {
            return Parameters.deconstruct(this.currentValue()).dateTime();
        }

        @MemberSupport
        public String defaultCalendarName(Parameters p) {
            return Parameters.deconstruct(this.currentValue()).calendarName();
        }

        @MemberSupport
        public String defaultTitle(Parameters p) {
            return Parameters.deconstruct(this.currentValue()).title();
        }

        @MemberSupport
        public String defaultNotes(Parameters p) {
            return Parameters.deconstruct(this.currentValue()).notes();
        }

        private CalendarEvent currentValue() {
            return this.mixee;
        }

        @Generated
        public CalendarEvent_default(CalendarEvent mixee) {
            this.mixee = mixee;
        }
    }

    public record Parameters(LocalDateTime dateTime, String calendarName, String title, String notes) {
        public CalendarEvent construct() {
            ZoneId zoneId = ZoneId.systemDefault();
            return new CalendarEvent(this.dateTime().atZone(zoneId).toInstant().toEpochMilli(), this.calendarName(), this.title(), this.notes());
        }

        public static Parameters deconstruct(CalendarEvent value) {
            ZoneId zoneId = ZoneId.systemDefault();
            return new Parameters(value.asDateTime(zoneId).toLocalDateTime(), value.getCalendarName(), value.getTitle(), value.getNotes());
        }
    }
}

