/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.pdfjs.metamodel.facet;

import jakarta.inject.Inject;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facetapi.FacetWithAttributes;
import org.apache.causeway.extensions.pdfjs.applib.annotations.PdfJsViewer;
import org.apache.causeway.extensions.pdfjs.applib.config.PdfJsConfig;
import org.apache.causeway.extensions.pdfjs.applib.config.Scale;
import org.apache.causeway.extensions.pdfjs.applib.spi.PdfJsViewerAdvisor;
import org.apache.causeway.extensions.pdfjs.metamodel.facet.PdfJsViewerFacetAbstract;

public class PdfJsViewerFacetFromAnnotation
extends PdfJsViewerFacetAbstract
implements FacetWithAttributes {
    private final int initialHeight;
    private final int initialPage;
    private final Scale initialScale;
    @Inject
    List<PdfJsViewerAdvisor> advisors;

    public PdfJsViewerFacetFromAnnotation(PdfJsConfig config, FacetHolder holder) {
        super(config, holder);
        this.initialHeight = config.getInitialHeight();
        this.initialPage = config.getInitialPage();
        this.initialScale = config.getInitialScale();
    }

    public static PdfJsViewerFacetFromAnnotation create(PdfJsViewer annotation, FacetHolder holder) {
        PdfJsConfig config = new PdfJsConfig().withInitialPage(annotation.initialPageNum()).withInitialScale(annotation.initialScale()).withInitialHeight(annotation.initialHeight());
        return new PdfJsViewerFacetFromAnnotation(config, holder);
    }

    @Override
    public PdfJsConfig configFor(PdfJsViewerAdvisor.InstanceKey instanceKey) {
        PdfJsConfig config = super.configFor(instanceKey);
        if (this.advisors != null) {
            for (PdfJsViewerAdvisor advisor : this.advisors) {
                Integer height;
                Scale scale;
                PdfJsViewerAdvisor.Advice advice = advisor.advise(instanceKey);
                if (advice == null) continue;
                Integer pageNum = advice.pageNum();
                if (pageNum != null) {
                    config = config.withInitialPage(pageNum.intValue());
                }
                if ((scale = advice.scale()) != null) {
                    config = config.withInitialScale(scale);
                }
                if ((height = advice.height()) == null) break;
                config = config.withInitialHeight(height.intValue());
                break;
            }
        }
        return config;
    }

    public void visitAttributes(BiConsumer<String, Object> visitor) {
        super.visitAttributes(visitor);
        visitor.accept("initialScale", this.initialScale);
        visitor.accept("initialHeight", this.initialHeight);
        visitor.accept("initialPage", this.initialPage);
    }
}

