/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.pdfjs.wkt.ui.components;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.util.Map;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.user.UserService;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.MmUnwrapUtils;
import org.apache.causeway.extensions.pdfjs.applib.config.PdfJsConfig;
import org.apache.causeway.extensions.pdfjs.applib.config.Scale;
import org.apache.causeway.extensions.pdfjs.applib.spi.PdfJsViewerAdvisor;
import org.apache.causeway.extensions.pdfjs.metamodel.facet.PdfJsViewerFacet;
import org.apache.causeway.extensions.pdfjs.wkt.integration.components.PdfJsPanel;
import org.apache.causeway.extensions.pdfjs.wkt.ui.components.PdfJsViewerCallbacksReference;
import org.apache.causeway.extensions.pdfjs.wkt.ui.components.PdfJsViewerCssReference;
import org.apache.causeway.extensions.pdfjs.wkt.ui.components.PdfJsViewerJsReference;
import org.apache.causeway.extensions.pdfjs.wkt.ui.components.ScalarPanelAbstractLegacy;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.util.ResourceLinkVolatile;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.ListenerRequestHandler;
import org.apache.wicket.core.request.handler.PageAndComponentProvider;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceRequestHandler;
import org.apache.wicket.request.http.flow.AbortWithHttpErrorCodeException;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.ByteArrayResource;
import org.apache.wicket.request.resource.IResource;
import org.jspecify.annotations.NonNull;

class PdfJsViewerPanel
extends ScalarPanelAbstractLegacy
implements IRequestListener {
    private static final long serialVersionUID = 1L;
    private static final String ID_SCALAR_IF_REGULAR = "regularFrame";
    private static final String ID_SCALAR_IF_COMPACT = "compactFrame";
    private static final String ID_SCALAR_NAME = "scalarName";
    private static final String ID_SCALAR_VALUE = "scalarValue";
    private static final String ID_FEEDBACK = "feedback";
    private static final String ID_DOWNLOAD = "download";
    private static final String ID_FILE_NAME_IF_COMPACT = "compactFrame-fileName";
    private static final String ID_DOWNLOAD_IF_COMPACT = "compactFrame-download";
    AbstractDefaultAjaxBehavior updatePageNum;
    AbstractDefaultAjaxBehavior updateScale;
    AbstractDefaultAjaxBehavior updateHeight;

    PdfJsViewerPanel(String id, UiAttributeWkt attributeModel) {
        super(id, attributeModel);
    }

    @Override
    protected void onBeforeRender() {
        super.onBeforeRender();
        this.updatePageNum = new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget _target) {
                String newPageNum = RequestCycle.get().getRequest().getRequestParameters().getParameterValue("pageNum").toString();
                try {
                    int pageNum = Integer.parseInt(newPageNum);
                    Updater updater = (advisor, renderKey) -> advisor.pageNumChangedTo(renderKey, pageNum);
                    PdfJsViewerPanel.this.updateAdvisors(updater);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.updateScale = new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget _target) {
                String newScale = RequestCycle.get().getRequest().getRequestParameters().getParameterValue("scale").toString();
                try {
                    Scale scale = Scale.forValue((String)newScale);
                    Updater updater = (advisor, renderKey) -> advisor.scaleChangedTo(renderKey, scale);
                    PdfJsViewerPanel.this.updateAdvisors(updater);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.updateHeight = new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void respond(AjaxRequestTarget _target) {
                String newHeight = RequestCycle.get().getRequest().getRequestParameters().getParameterValue("height").toString();
                try {
                    int height = Integer.parseInt(newHeight);
                    Updater updater = (advisor, renderKey) -> advisor.heightChangedTo(renderKey, height);
                    PdfJsViewerPanel.this.updateAdvisors(updater);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.add(new Behavior[]{this.updatePageNum, this.updateScale, this.updateHeight});
    }

    private void updateAdvisors(Updater updater) {
        PdfJsViewerAdvisor.InstanceKey instanceKey = this.buildKey();
        this.getServiceRegistry().select(PdfJsViewerAdvisor.class).forEach(advisor -> updater.update((PdfJsViewerAdvisor)advisor, instanceKey));
    }

    private PdfJsViewerAdvisor.InstanceKey buildKey() {
        return this.getServiceRegistry().lookupService(UserService.class).map(this::toInstanceKey).orElseThrow(() -> new IllegalStateException("Could not locate UserService"));
    }

    private PdfJsViewerAdvisor.InstanceKey toInstanceKey(UserService userService) {
        String userName = userService.currentUserNameElseNobody();
        UiAttributeWkt attributeModel = (UiAttributeWkt)this.getModel();
        String propertyId = attributeModel.getIdentifier();
        Bookmark bookmark = attributeModel.getParentUiModel().getOwnerBookmark();
        String logicalTypeName = bookmark.logicalTypeName();
        String identifier = bookmark.identifier();
        return new PdfJsViewerAdvisor.InstanceKey(logicalTypeName, identifier, propertyId, userName);
    }

    @Override
    protected MarkupContainer createRegularFrame() {
        Blob blob = this.getBlob();
        if (blob == null || _NullSafe.isEmpty((byte[])blob.bytes())) {
            return this.createShallowRegularFrame();
        }
        UiAttributeWkt attributeModel = this.attributeModel();
        WebMarkupContainer regularFrame = new WebMarkupContainer(ID_SCALAR_IF_REGULAR);
        String documentUrl = String.valueOf(this.urlFor((IRequestHandler)new ListenerRequestHandler(new PageAndComponentProvider((IRequestablePage)this.getPage(), (IRequestableComponent)this)))) + "&md5=" + blob.md5Hex();
        PdfJsConfig pdfJsConfig = attributeModel.getMetaModel().lookupFacet(PdfJsViewerFacet.class).map(pdfJsViewerFacet -> pdfJsViewerFacet.configFor(this.buildKey())).orElseGet(PdfJsConfig::new).withDocumentUrl((CharSequence)documentUrl);
        PdfJsPanel pdfJsPanel = new PdfJsPanel(ID_SCALAR_VALUE, pdfJsConfig);
        MarkupContainer prevPageButton = this.createToolbarComponent("prevPage", pdfJsPanel);
        MarkupContainer nextPageButton = this.createToolbarComponent("nextPage", pdfJsPanel);
        MarkupContainer currentZoomSelect = this.createToolbarComponent("currentZoom", pdfJsPanel);
        MarkupContainer currentPageLabel = this.createToolbarComponent("currentPage", pdfJsPanel);
        MarkupContainer totalPagesLabel = this.createToolbarComponent("totalPages", pdfJsPanel);
        MarkupContainer currentHeightSelect = this.createToolbarComponent("currentHeight", pdfJsPanel);
        MarkupContainer printButton = this.createToolbarComponent("print", pdfJsPanel);
        ResourceLinkVolatile downloadResourceLink = Wkt.downloadLinkNoCache((String)ID_DOWNLOAD, (IResource)PdfJsViewerPanel.asBlobResource(blob));
        regularFrame.addOrReplace(new Component[]{pdfJsPanel, prevPageButton, nextPageButton, currentPageLabel, totalPagesLabel, currentZoomSelect, currentHeightSelect, printButton, downloadResourceLink, new NotificationPanel(ID_FEEDBACK, (Component)pdfJsPanel, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter((Component)pdfJsPanel))});
        return regularFrame;
    }

    @Override
    protected MarkupContainer createShallowRegularFrame() {
        WebMarkupContainer shallowRegularFrame = new WebMarkupContainer(ID_SCALAR_IF_REGULAR);
        WktComponents.permanentlyHide((MarkupContainer)shallowRegularFrame, (String[])new String[]{ID_SCALAR_NAME, ID_SCALAR_VALUE, ID_FEEDBACK, ID_DOWNLOAD});
        return shallowRegularFrame;
    }

    @Override
    protected Component createCompactFrame() {
        Blob blob = this.getBlob();
        if (blob == null) {
            return this.createShallowCompactFrame();
        }
        WebMarkupContainer compactFrame = new WebMarkupContainer(ID_SCALAR_IF_COMPACT);
        ResourceLinkVolatile downloadLink = (ResourceLinkVolatile)Wkt.add((MarkupContainer)compactFrame, (Component)Wkt.downloadLinkNoCache((String)ID_DOWNLOAD_IF_COMPACT, (IResource)PdfJsViewerPanel.asBlobResource(blob)));
        Wkt.labelAdd((MarkupContainer)downloadLink, (String)ID_FILE_NAME_IF_COMPACT, (String)blob.name());
        return compactFrame;
    }

    @Override
    protected Component createShallowCompactFrame() {
        WebMarkupContainer shallowCompactFrame = new WebMarkupContainer(ID_SCALAR_IF_COMPACT);
        WktComponents.permanentlyHide((MarkupContainer)shallowCompactFrame, (String[])new String[]{ID_DOWNLOAD_IF_COMPACT, ID_FILE_NAME_IF_COMPACT});
        return shallowCompactFrame;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render(PdfJsViewerCssReference.asHeaderItem());
        response.render(PdfJsViewerJsReference.asHeaderItem());
        String script = PdfJsViewerCallbacksReference.instance().asString(Map.of("pageNumCallbackUrl", this.updatePageNum.getCallbackUrl(), "scaleCallbackUrl", this.updateScale.getCallbackUrl(), "heightCallbackUrl", this.updateHeight.getCallbackUrl()));
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)script, (String)"pdfJsViewerCallbacks"));
    }

    public boolean rendersPage() {
        return false;
    }

    public void onRequest() {
        Blob blob = this.getBlob();
        if (blob == null) {
            throw new AbortWithHttpErrorCodeException(404);
        }
        this.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceRequestHandler((IResource)PdfJsViewerPanel.asBlobResourceNoCache(blob), null));
    }

    private Blob getBlob() {
        return (Blob)MmUnwrapUtils.single((ManagedObject)this.attributeModel().getObject());
    }

    private static ByteArrayResource asBlobResource(@NonNull Blob blob) {
        return new ByteArrayResource(blob.mimeType().getBaseType(), blob.bytes(), blob.name());
    }

    private static ByteArrayResource asBlobResourceNoCache(@NonNull Blob blob) {
        byte[] bytes = blob.bytes();
        return new ByteArrayResource("application/pdf", bytes){
            private static final long serialVersionUID = 1L;

            protected void configureResponse(AbstractResource.ResourceResponse response, IResource.Attributes attributes) {
                super.configureResponse(response, attributes);
                response.disableCaching();
            }
        };
    }

    private MarkupContainer createToolbarComponent(String id, final PdfJsPanel pdfJsPanel) {
        return new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("data-canvas-id", pdfJsPanel.getCanvasId());
            }
        };
    }

    static interface Updater {
        public void update(PdfJsViewerAdvisor var1, PdfJsViewerAdvisor.InstanceKey var2);
    }
}

