/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.pdfjs.wkt.ui.components;

import jakarta.inject.Inject;
import org.apache.causeway.applib.value.Blob;
import org.apache.causeway.applib.value.NamedWithMimeType;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.extensions.pdfjs.metamodel.facet.PdfJsViewerFacet;
import org.apache.causeway.extensions.pdfjs.wkt.ui.components.PdfJsViewerPanel;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

@org.springframework.stereotype.Component
public class PdfJsViewerPanelComponentFactory
extends ComponentFactoryAbstract {
    @Inject
    public PdfJsViewerPanelComponentFactory() {
        super(UiComponentType.ATTRIBUTE_NAME_AND_VALUE, PdfJsViewerPanel.class);
    }

    public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        if (!(model instanceof UiAttributeWkt)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        UiAttributeWkt attributeModel = (UiAttributeWkt)model;
        if (!attributeModel.getMetaModel().containsFacet(PdfJsViewerFacet.class)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        return this.appliesIf(PdfJsViewerPanelComponentFactory.isPdf(attributeModel.getObject()));
    }

    private static boolean isPdf(ManagedObject objectAdapter) {
        if (objectAdapter == null) {
            return false;
        }
        Object objectPojo = objectAdapter.getPojo();
        if (!(objectPojo instanceof Blob)) {
            return false;
        }
        Blob blob = (Blob)objectPojo;
        return NamedWithMimeType.CommonMimeType.PDF.matches(blob.getMimeType());
    }

    public Component createComponent(String id, IModel<?> model) {
        return new PdfJsViewerPanel(id, (UiAttributeWkt)model);
    }
}

