/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.integration.authenticator;

import jakarta.inject.Inject;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.causeway.applib.services.iactnlayer.InteractionContext;
import org.apache.causeway.applib.services.user.UserMemento;
import org.apache.causeway.core.security.authentication.AuthenticationRequest;
import org.apache.causeway.core.security.authentication.AuthenticationRequestPassword;
import org.apache.causeway.core.security.authentication.Authenticator;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.crypto.password.PasswordEncoder;

public class AuthenticatorSecman
implements Authenticator {
    @Generated
    private static final Logger log = LogManager.getLogger(AuthenticatorSecman.class);
    private final ApplicationUserRepository applicationUserRepository;
    private final PasswordEncoder passwordEncoder;

    @Inject
    public AuthenticatorSecman(ApplicationUserRepository applicationUserRepository, @Qualifier(value="Secman") PasswordEncoder passwordEncoder) {
        this.applicationUserRepository = applicationUserRepository;
        this.passwordEncoder = passwordEncoder;
    }

    public final boolean canAuthenticate(Class<? extends AuthenticationRequest> authenticationRequestClass) {
        return AuthenticationRequestPassword.class.isAssignableFrom(authenticationRequestClass);
    }

    public InteractionContext authenticate(AuthenticationRequest request, String code) {
        AuthenticationRequestPassword authRequest = (AuthenticationRequestPassword)request;
        String username = authRequest.getName();
        String rawPassword = authRequest.getPassword();
        if (username == null) {
            log.info("login failed: username is null");
            return null;
        }
        return this.applicationUserRepository.findByUsername(username).filter(appUser -> ApplicationUserStatus.isUnlocked((ApplicationUserStatus)appUser.getStatus())).filter(appUser -> appUser.isHasPassword()).filter(appUser -> this.passwordEncoder.matches((CharSequence)rawPassword, appUser.getEncryptedPassword())).map(appUser -> {
            Stream<String> roleNames = Stream.concat(appUser.getRoles().stream().map(ApplicationRole::getName), request.streamRoles());
            UserMemento user = UserMemento.ofNameAndRoleNames((String)username, roleNames).withAuthenticationCode(code);
            return InteractionContext.ofUserWithSystemDefaults((UserMemento)user);
        }).orElse(null);
    }

    public void logout() {
    }
}

