/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.integration.authorizor;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.annotation.InteractionScope;
import org.apache.causeway.applib.id.LogicalType;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.applib.services.iactnlayer.InteractionContext;
import org.apache.causeway.applib.services.metamodel.MetaModelService;
import org.apache.causeway.commons.internal.base._Lazy;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.core.security.authentication.logout.LogoutMenu;
import org.apache.causeway.core.security.authorization.Authorizor;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionValueSet;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.jspecify.annotations.NonNull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.ext.secman.AuthorizorSecman")
@Priority(value=0x1FFFFFF5)
@Qualifier(value="Secman")
public class AuthorizorSecman
implements Authorizor {
    @Inject
    ApplicationUserRepository applicationUserRepository;
    @Inject
    Provider<PermissionCache> cache;
    @Inject
    MetaModelService metaModelService;
    private _Lazy<Identifier> logoutIdentifier = _Lazy.threadSafe(this::logoutIdentifier);

    private Identifier logoutIdentifier() {
        return Identifier.actionIdentifier((LogicalType)((LogicalType)this.metaModelService.lookupLogicalTypeByClass(LogoutMenu.class).orElseThrow()), (String)"logout", (Class[])new Class[0]);
    }

    public boolean isVisible(InteractionContext authentication, Identifier identifier) {
        if (((Identifier)this.logoutIdentifier.get()).equals((Object)identifier)) {
            return true;
        }
        return this.grants(authentication, identifier, ApplicationPermissionMode.VIEWING);
    }

    public boolean isUsable(InteractionContext authentication, Identifier identifier) {
        if (((Identifier)this.logoutIdentifier.get()).equals((Object)identifier)) {
            return true;
        }
        return this.grants(authentication, identifier, ApplicationPermissionMode.CHANGING);
    }

    private boolean grants(InteractionContext authentication, Identifier identifier, ApplicationPermissionMode permissionMode) {
        String userName = authentication.getUser().name();
        Optional<ApplicationPermissionValueSet> permissionSetIfAny = ((PermissionCache)this.cache.get()).computeIfAbsent(userName, () -> this.applicationUserRepository.findByUsername(userName).map(ApplicationUser::getPermissionSet));
        return permissionSetIfAny.map(permissionSet -> permissionSet.grants(ApplicationFeatureId.fromIdentifier((Identifier)identifier), permissionMode)).orElse(false);
    }

    @Component
    @Named(value="causeway.ext.secman.AuthorizorSecman.PermissionCache")
    @InteractionScope
    static class PermissionCache
    implements DisposableBean {
        private final Map<String, Optional<ApplicationPermissionValueSet>> permissionsByUsername = _Maps.newHashMap();

        PermissionCache() {
        }

        public void destroy() {
            this.permissionsByUsername.clear();
        }

        Optional<ApplicationPermissionValueSet> computeIfAbsent(@NonNull String userName, Supplier<Optional<ApplicationPermissionValueSet>> lookup) {
            return this.permissionsByUsername.computeIfAbsent(userName, (? super K __) -> (Optional)lookup.get());
        }
    }
}

