/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.integration.facets;

import jakarta.inject.Provider;
import java.util.List;
import java.util.Optional;
import org.apache.causeway.applib.services.queryresultscache.QueryResultsCache;
import org.apache.causeway.applib.services.user.UserService;
import org.apache.causeway.core.metamodel.consent.Consent;
import org.apache.causeway.core.metamodel.facetapi.Facet;
import org.apache.causeway.core.metamodel.facetapi.FacetAbstract;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.interactions.InteractionHead;
import org.apache.causeway.core.metamodel.interactions.use.UsabilityContext;
import org.apache.causeway.core.metamodel.interactions.vis.VisibilityContext;
import org.apache.causeway.extensions.secman.applib.tenancy.spi.ApplicationTenancyEvaluator;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.apache.causeway.extensions.secman.integration.facets.TenantedAuthorizationFacet;

public class TenantedAuthorizationFacetDefault
extends FacetAbstract
implements TenantedAuthorizationFacet {
    private final List<ApplicationTenancyEvaluator> evaluators;
    private final ApplicationUserRepository applicationUserRepository;
    private final UserService userService;
    private final Provider<QueryResultsCache> queryResultsCacheProvider;

    private static Class<? extends Facet> type() {
        return TenantedAuthorizationFacet.class;
    }

    public TenantedAuthorizationFacetDefault(List<ApplicationTenancyEvaluator> evaluators, ApplicationUserRepository applicationUserRepository, Provider<QueryResultsCache> queryResultsCacheProvider, UserService userService, FacetHolder holder) {
        super(TenantedAuthorizationFacetDefault.type(), holder);
        this.evaluators = evaluators;
        this.applicationUserRepository = applicationUserRepository;
        this.queryResultsCacheProvider = queryResultsCacheProvider;
        this.userService = userService;
    }

    public String hides(VisibilityContext ic) {
        return this.evaluate(ApplicationTenancyEvaluator::hides, ic.head()).orElse(null);
    }

    public Optional<Consent.VetoReason> disables(UsabilityContext ic) {
        return this.evaluate(ApplicationTenancyEvaluator::disables, ic.head()).map(Consent.VetoReason::explicit);
    }

    private Optional<String> evaluate(EvaluationDispatcher evaluationDispatcher, InteractionHead head) {
        if (this.evaluators == null || this.evaluators.isEmpty() || this.userService.isCurrentUserWithSudoAccessAllRole()) {
            return Optional.empty();
        }
        Object domainObject = head.owner().getPojo();
        String userName = this.userService.currentUserNameElseNobody();
        ApplicationUser applicationUser = this.findApplicationUser(userName);
        if (applicationUser == null) {
            return Optional.of("Could not locate application user for " + userName);
        }
        for (ApplicationTenancyEvaluator evaluator : this.evaluators) {
            String reasonString = evaluationDispatcher.dispatch(evaluator, domainObject, applicationUser);
            if (reasonString == null) continue;
            return Optional.of(reasonString);
        }
        return Optional.empty();
    }

    protected ApplicationUser findApplicationUser(String userName) {
        return (ApplicationUser)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(() -> this.findApplicationUserNoCache(userName), TenantedAuthorizationFacetDefault.class, "findApplicationUser", new Object[]{userName});
    }

    protected ApplicationUser findApplicationUserNoCache(String userName) {
        return this.applicationUserRepository.findByUsername(userName).orElse(null);
    }

    static interface EvaluationDispatcher {
        public String dispatch(ApplicationTenancyEvaluator var1, Object var2, ApplicationUser var3);
    }
}

