/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.integration.facets;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.causeway.applib.services.queryresultscache.QueryResultsCache;
import org.apache.causeway.applib.services.user.UserService;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facetapi.FacetUtil;
import org.apache.causeway.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.causeway.core.metamodel.postprocessors.MetaModelPostProcessor;
import org.apache.causeway.core.metamodel.postprocessors.MetaModelPostProcessorAbstract;
import org.apache.causeway.core.metamodel.progmodel.ProgrammingModel;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.extensions.secman.applib.tenancy.spi.ApplicationTenancyEvaluator;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.apache.causeway.extensions.secman.integration.facets.TenantedAuthorizationFacetDefault;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.stereotype.Component;

public class TenantedAuthorizationPostProcessor
extends MetaModelPostProcessorAbstract {
    @Inject
    Provider<UserService> userServiceProvider;
    @Inject
    Provider<ApplicationUserRepository> userRepositoryProvider;
    @Inject
    Provider<QueryResultsCache> queryResultsCacheProvider;
    @Inject
    ObjectProvider<ApplicationTenancyEvaluator> applicationTenancyEvaluators;

    @Inject
    public TenantedAuthorizationPostProcessor(MetaModelContext metaModelContext) {
        super(metaModelContext);
    }

    public void postProcessObject(ObjectSpecification objectSpecification) {
        FacetUtil.addFacetIfPresent(this.createFacet(objectSpecification.getCorrespondingClass(), (FacetHolder)objectSpecification));
    }

    public void postProcessAction(ObjectSpecification objectSpecification, ObjectAction act) {
        this.addFacetTo(objectSpecification, (ObjectFeature)act);
    }

    public void postProcessProperty(ObjectSpecification objectSpecification, OneToOneAssociation prop) {
        this.addFacetTo(objectSpecification, (ObjectFeature)prop);
    }

    public void postProcessCollection(ObjectSpecification objectSpecification, OneToManyAssociation coll) {
        this.addFacetTo(objectSpecification, (ObjectFeature)coll);
    }

    private void addFacetTo(ObjectSpecification specification, ObjectFeature objectFeature) {
        FacetUtil.addFacetIfPresent(this.createFacet(specification.getCorrespondingClass(), (FacetHolder)objectFeature));
    }

    private Optional<TenantedAuthorizationFacetDefault> createFacet(Class<?> cls, FacetHolder holder) {
        List<ApplicationTenancyEvaluator> evaluators = this.applicationTenancyEvaluators.orderedStream().filter(evaluator -> evaluator.handles(cls)).collect(Collectors.toList());
        return evaluators.isEmpty() ? Optional.empty() : Optional.of(new TenantedAuthorizationFacetDefault(evaluators, (ApplicationUserRepository)this.userRepositoryProvider.get(), this.queryResultsCacheProvider, (UserService)this.userServiceProvider.get(), holder));
    }

    @Component
    public static class Register
    implements MetaModelRefiner {
        public void refineProgrammingModel(ProgrammingModel programmingModel) {
            programmingModel.addPostProcessor(ProgrammingModel.PostProcessingOrder.A2_AFTER_BUILTIN, (MetaModelPostProcessor)new TenantedAuthorizationPostProcessor(programmingModel.getMetaModelContext()), new ProgrammingModel.Marker[0]);
        }
    }
}

