/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.integration.permissions;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.commons.internal.assertions._Assert;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionValue;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionValueSet;
import org.apache.causeway.extensions.secman.applib.permission.spi.PermissionsEvaluationService;
import org.apache.causeway.extensions.secman.integration.permissions.ApplicationFeatureIdTransformer;
import org.jspecify.annotations.NonNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.ext.secman.PermissionsEvaluationServiceForSecman")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Secman")
public class PermissionsEvaluationServiceForSecman
implements PermissionsEvaluationService {
    private static final long serialVersionUID = 1L;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CausewayConfiguration.Extensions.Secman.PermissionsEvaluationPolicy policy;
    @Inject
    ApplicationFeatureIdTransformer applicationFeatureIdTransformer;

    private PermissionsEvaluationServiceForSecman(CausewayConfiguration.Extensions.Secman.PermissionsEvaluationPolicy policy, ApplicationFeatureIdTransformer applicationFeatureIdTransformer) {
        this.policy = policy;
        this.applicationFeatureIdTransformer = applicationFeatureIdTransformer;
    }

    @Inject
    public PermissionsEvaluationServiceForSecman(CausewayConfiguration causewayConfiguration) {
        this.policy = Optional.ofNullable(causewayConfiguration.getExtensions().getSecman().getPermissionsEvaluationPolicy()).orElseGet(() -> new CausewayConfiguration.Extensions.Secman().getPermissionsEvaluationPolicy());
        _Assert.assertNotNull((Object)this.policy);
    }

    public ApplicationPermissionValueSet.Evaluation evaluate(ApplicationFeatureId targetMemberIdInput, ApplicationPermissionMode mode, Collection<ApplicationPermissionValue> permissionValuesInput) {
        ApplicationFeatureId targetMemberId = this.applicationFeatureIdTransformer.transform(targetMemberIdInput);
        Collection<ApplicationPermissionValue> permissionValues = this.applicationFeatureIdTransformer.transform(permissionValuesInput);
        if (_NullSafe.isEmpty(permissionValues)) {
            return null;
        }
        Collection<ApplicationPermissionValue> ordered = this.ordered(permissionValues);
        for (ApplicationPermissionValue permissionValue : ordered) {
            if (permissionValue.implies(targetMemberId, mode)) {
                return new ApplicationPermissionValueSet.Evaluation(permissionValue, true);
            }
            if (!permissionValue.refutes(targetMemberId, mode)) continue;
            return new ApplicationPermissionValueSet.Evaluation(permissionValue, false);
        }
        return null;
    }

    protected Collection<ApplicationPermissionValue> ordered(Collection<ApplicationPermissionValue> permissionValues) {
        switch (this.policy) {
            case ALLOW_BEATS_VETO: {
                return permissionValues;
            }
            case VETO_BEATS_ALLOW: {
                ArrayList reversed = _Lists.newArrayList(permissionValues);
                Collections.reverse(reversed);
                return reversed;
            }
        }
        throw _Exceptions.illegalArgument((String)"PermissionsEvaluationPolicy '%s' not recognised", (Object[])new Object[]{this.policy});
    }

    @Generated
    public static PermissionsEvaluationServiceForSecmanBuilder builder() {
        return new PermissionsEvaluationServiceForSecmanBuilder();
    }

    @Generated
    public static class PermissionsEvaluationServiceForSecmanBuilder {
        @Generated
        private CausewayConfiguration.Extensions.Secman.PermissionsEvaluationPolicy policy;
        @Generated
        private ApplicationFeatureIdTransformer applicationFeatureIdTransformer;

        @Generated
        PermissionsEvaluationServiceForSecmanBuilder() {
        }

        @Generated
        public PermissionsEvaluationServiceForSecmanBuilder policy(CausewayConfiguration.Extensions.Secman.PermissionsEvaluationPolicy policy) {
            this.policy = policy;
            return this;
        }

        @Generated
        public PermissionsEvaluationServiceForSecmanBuilder applicationFeatureIdTransformer(ApplicationFeatureIdTransformer applicationFeatureIdTransformer) {
            this.applicationFeatureIdTransformer = applicationFeatureIdTransformer;
            return this;
        }

        @Generated
        public PermissionsEvaluationServiceForSecman build() {
            return new PermissionsEvaluationServiceForSecman(this.policy, this.applicationFeatureIdTransformer);
        }

        @Generated
        public String toString() {
            return "PermissionsEvaluationServiceForSecman.PermissionsEvaluationServiceForSecmanBuilder(policy=" + String.valueOf(this.policy) + ", applicationFeatureIdTransformer=" + String.valueOf(this.applicationFeatureIdTransformer) + ")";
        }
    }
}

