/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.integration.spiimpl;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.applib.annotation.InteractionScope;
import org.apache.causeway.applib.services.message.MessageService;
import org.apache.causeway.applib.services.user.ImpersonateMenuAdvisor;
import org.apache.causeway.applib.services.user.UserService;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserStatus;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.ext.secman.ImpersonateMenuAdvisorForSecman")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Secman")
public class ImpersonateMenuAdvisorForSecman
implements ImpersonateMenuAdvisor {
    final ApplicationUserRepository applicationUserRepository;
    final ApplicationRoleRepository applicationRoleRepository;
    final UserService userService;
    final MessageService messageService;
    final Provider<Cache> cache;

    public List<String> allUserNames() {
        return ((Cache)this.cache.get()).allUserNamesComputeIfAbsent(() -> this.applicationUserRepository.allUsers().stream().filter(x -> x.getStatus() == ApplicationUserStatus.UNLOCKED).map(ApplicationUser::getUsername).collect(Collectors.toList()));
    }

    public List<String> allRoleNames() {
        return ((Cache)this.cache.get()).allRoleNamesComputeIfAbsent(() -> this.applicationRoleRepository.allRoles().stream().map(ApplicationRole::getName).collect(Collectors.toList()));
    }

    public List<String> roleNamesFor(String username) {
        if (username == null) {
            return Collections.emptyList();
        }
        ApplicationUser applicationUser = (ApplicationUser)this.applicationUserRepository.findByUsername(username).orElseThrow(RuntimeException::new);
        Set applicationRoles = applicationUser.getRoles();
        return applicationRoles.stream().map(ApplicationRole::getName).collect(Collectors.toList());
    }

    public String multiTenancyTokenFor(String username) {
        if (username == null) {
            return null;
        }
        ApplicationUser applicationUser = (ApplicationUser)this.applicationUserRepository.findByUsername(username).orElseThrow(RuntimeException::new);
        return applicationUser.getAtPath();
    }

    @Inject
    @Generated
    public ImpersonateMenuAdvisorForSecman(ApplicationUserRepository applicationUserRepository, ApplicationRoleRepository applicationRoleRepository, UserService userService, MessageService messageService, Provider<Cache> cache) {
        this.applicationUserRepository = applicationUserRepository;
        this.applicationRoleRepository = applicationRoleRepository;
        this.userService = userService;
        this.messageService = messageService;
        this.cache = cache;
    }

    @Component
    @Named(value="causeway.ext.secman.ImpersonateMenuAdvisorForSecman.Cache")
    @InteractionScope
    static class Cache
    implements DisposableBean {
        private List<String> allUserNames;
        private List<String> allRoleNames;

        Cache() {
        }

        public void destroy() throws Exception {
            this.allUserNames = null;
            this.allRoleNames = null;
        }

        List<String> allUserNamesComputeIfAbsent(Supplier<List<String>> lookup) {
            if (this.allUserNames != null) {
                return this.allUserNames;
            }
            this.allUserNames = lookup.get();
            return this.allUserNames;
        }

        List<String> allRoleNamesComputeIfAbsent(Supplier<List<String>> lookup) {
            if (this.allRoleNames != null) {
                return this.allRoleNames;
            }
            this.allRoleNames = lookup.get();
            return this.allRoleNames;
        }
    }
}

