/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.integration.usermementorefiner;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.applib.services.user.UserMemento;
import org.apache.causeway.core.security.authentication.manager.UserMementoRefiner;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.springframework.stereotype.Service;

@Service
public class UserMementoRefinerFromApplicationUser
implements UserMementoRefiner {
    final Provider<ApplicationUserRepository> applicationUserRepositoryProvider;

    public UserMemento refine(UserMemento userMemento) {
        Optional applicationUserIfAny = ((ApplicationUserRepository)this.applicationUserRepositoryProvider.get()).findByUsername(userMemento.name());
        if (applicationUserIfAny.isEmpty()) {
            return userMemento;
        }
        ApplicationUser applicationUser = (ApplicationUser)applicationUserIfAny.get();
        UserMemento refinedUserMemento = userMemento.withMultiTenancyToken(applicationUser.getAtPath()).withLanguageLocale(applicationUser.getLanguage()).withNumberFormatLocale(applicationUser.getNumberFormat()).withTimeFormatLocale(applicationUser.getTimeFormat());
        for (ApplicationRole role : applicationUser.getRoles()) {
            refinedUserMemento = refinedUserMemento.withRoleAdded(role.getName());
        }
        return refinedUserMemento;
    }

    @Inject
    @Generated
    public UserMementoRefinerFromApplicationUser(Provider<ApplicationUserRepository> applicationUserRepositoryProvider) {
        this.applicationUserRepositoryProvider = applicationUserRepositoryProvider;
    }
}

