/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.integration.userreg;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.applib.services.userreg.UserDetails;
import org.apache.causeway.applib.services.userreg.UserRegistrationService;
import org.apache.causeway.applib.value.Password;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserStatus;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.ext.secman.UserRegistrationServiceForSecman")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Secman")
public class UserRegistrationServiceForSecman
implements UserRegistrationService {
    private final ApplicationUserRepository applicationUserRepository;
    private final ApplicationRoleRepository applicationRoleRepository;
    private final CausewayConfiguration causewayConfiguration;

    public boolean usernameExists(String username) {
        return this.applicationUserRepository.findByUsername(username).isPresent();
    }

    public void registerUser(UserDetails userDetails) {
        Password password = new Password(userDetails.getPassword());
        String username = userDetails.getUsername();
        String emailAddress = userDetails.getEmailAddress();
        ApplicationUser applicationUser = this.applicationUserRepository.newLocalUser(username, password, ApplicationUserStatus.UNLOCKED);
        if (_Strings.isNotEmpty((CharSequence)emailAddress)) {
            applicationUser.setEmailAddress(emailAddress);
        }
        this.causewayConfiguration.getExtensions().getSecman().getUserRegistration().getInitialRoleNames().stream().map(arg_0 -> ((ApplicationRoleRepository)this.applicationRoleRepository).findByName(arg_0)).filter(Optional::isPresent).map(Optional::get).forEach(role -> this.applicationRoleRepository.addRoleToUser(role, applicationUser));
    }

    public boolean emailExists(String emailAddress) {
        return this.applicationUserRepository.findByEmailAddress(emailAddress).isPresent();
    }

    public boolean updatePasswordByEmail(String emailAddress, String password) {
        return this.applicationUserRepository.findByEmailAddress(emailAddress).map(user -> {
            boolean passwordWasUpdated = this.applicationUserRepository.updatePassword(user, password);
            return passwordWasUpdated;
        }).orElse(false);
    }

    @Inject
    @Generated
    public UserRegistrationServiceForSecman(ApplicationUserRepository applicationUserRepository, ApplicationRoleRepository applicationRoleRepository, CausewayConfiguration causewayConfiguration) {
        this.applicationUserRepository = applicationUserRepository;
        this.applicationRoleRepository = applicationRoleRepository;
        this.causewayConfiguration = causewayConfiguration;
    }
}

