/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.sessionlog.jpa.dom;

import jakarta.inject.Named;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.sql.Timestamp;
import java.util.UUID;
import lombok.Generated;
import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.Editing;
import org.apache.causeway.applib.services.session.SessionSubscriber;
import org.apache.causeway.extensions.sessionlog.applib.dom.SessionLogEntry;
import org.apache.causeway.extensions.sessionlog.jpa.dom.SessionLogEntryPK;
import org.apache.causeway.persistence.jpa.applib.integration.CausewayEntityListener;

@Entity
@Table(schema="causewayExtSessionLog", name="SessionLogEntry")
@NamedQueries(value={@NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findBySessionGuid", query="SELECT e   FROM SessionLogEntry e  WHERE e.pk.sessionGuid = :sessionGuid"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findByHttpSessionId", query="SELECT e   FROM SessionLogEntry e  WHERE e.httpSessionId = :httpSessionId"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findByUsernameAndTimestampBetween", query="SELECT e  FROM SessionLogEntry e  WHERE e.username = :username    AND e.loginTimestamp >= :from    AND e.logoutTimestamp <= :to  ORDER BY e.loginTimestamp DESC"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findByUsernameAndTimestampAfter", query="SELECT e  FROM SessionLogEntry e  WHERE e.username = :username    AND e.loginTimestamp >= :from  ORDER BY e.loginTimestamp DESC"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findByUsernameAndTimestampBefore", query="SELECT e  FROM SessionLogEntry e  WHERE e.username = :username    AND e.loginTimestamp <= :from  ORDER BY e.loginTimestamp DESC"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findByUsername", query="SELECT e  FROM SessionLogEntry e  WHERE e.username = :username  ORDER BY e.loginTimestamp DESC"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findByTimestampBetween", query="SELECT e  FROM SessionLogEntry e  WHERE e.loginTimestamp >= :from    AND e.logoutTimestamp <= :to  ORDER BY e.loginTimestamp DESC"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findByTimestampAfter", query="SELECT e  FROM SessionLogEntry e  WHERE e.loginTimestamp >= :from  ORDER BY e.loginTimestamp DESC"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findByTimestampBefore", query="SELECT e  FROM SessionLogEntry e  WHERE e.loginTimestamp <= :to  ORDER BY e.loginTimestamp DESC"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.find", query="SELECT e  FROM SessionLogEntry e  ORDER BY e.loginTimestamp DESC"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findByUsernameAndTimestampStrictlyBefore", query="SELECT e  FROM SessionLogEntry e  WHERE e.username = :username    AND e.loginTimestamp < :from  ORDER BY e.loginTimestamp DESC"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findByUsernameAndTimestampStrictlyAfter", query="SELECT e  FROM SessionLogEntry e  WHERE e.username = :username    AND e.loginTimestamp > :from  ORDER BY e.loginTimestamp ASC"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findActiveSessions", query="SELECT e  FROM SessionLogEntry e  WHERE e.logoutTimestamp IS null  ORDER BY e.loginTimestamp ASC"), @NamedQuery(name="causeway.ext.sessionLog.SessionLogEntry.findRecentByUsername", query="SELECT e  FROM SessionLogEntry e  WHERE e.username = :username  ORDER BY e.loginTimestamp DESC ")})
@EntityListeners(value={CausewayEntityListener.class})
@Named(value="causeway.ext.sessionLog.SessionLogEntry")
@DomainObject(editing=Editing.DISABLED)
public class SessionLogEntry
extends org.apache.causeway.extensions.sessionlog.applib.dom.SessionLogEntry {
    @EmbeddedId
    private SessionLogEntryPK pk;
    @Column(nullable=false, length=32)
    @SessionLogEntry.HttpSessionId
    private String httpSessionId;
    @Column(nullable=false, length=120)
    @SessionLogEntry.Username
    private String username;
    @Column(nullable=false)
    @SessionLogEntry.LoginTimestamp
    private Timestamp loginTimestamp;
    @Column(nullable=true)
    @SessionLogEntry.LogoutTimestamp
    private Timestamp logoutTimestamp;
    @Column(nullable=true)
    @SessionLogEntry.CausedBy
    private SessionSubscriber.CausedBy causedBy;

    public SessionLogEntry(UUID sessionGuid, String httpSessionId, String username, SessionSubscriber.CausedBy causedBy, Timestamp loginTimestamp) {
        super(sessionGuid, httpSessionId, username, causedBy, loginTimestamp);
    }

    public SessionLogEntry() {
        this(null, null, null, null, null);
    }

    @Transient
    @SessionLogEntry.SessionGuid
    public UUID getSessionGuid() {
        return this.pk != null ? this.pk.getSessionGuid() : null;
    }

    @Transient
    public void setSessionGuid(UUID sessionGuid) {
        this.pk = new SessionLogEntryPK(sessionGuid);
    }

    @Generated
    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    @Generated
    public void setHttpSessionId(String httpSessionId) {
        this.httpSessionId = httpSessionId;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public Timestamp getLoginTimestamp() {
        return this.loginTimestamp;
    }

    @Generated
    public void setLoginTimestamp(Timestamp loginTimestamp) {
        this.loginTimestamp = loginTimestamp;
    }

    @Generated
    public Timestamp getLogoutTimestamp() {
        return this.logoutTimestamp;
    }

    @Generated
    public void setLogoutTimestamp(Timestamp logoutTimestamp) {
        this.logoutTimestamp = logoutTimestamp;
    }

    @Generated
    public SessionSubscriber.CausedBy getCausedBy() {
        return this.causedBy;
    }

    @Generated
    public void setCausedBy(SessionSubscriber.CausedBy causedBy) {
        this.causedBy = causedBy;
    }
}

