/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.sessionlog.jpa.dom;

import jakarta.annotation.Priority;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Embeddable;
import java.io.Serializable;
import java.util.UUID;
import lombok.Generated;
import org.apache.causeway.applib.value.semantics.ValueSemanticsBasedOnIdStringifierEntityAgnostic;
import org.apache.causeway.persistence.jpa.integration.typeconverters.java.util.JavaUtilUuidConverter;
import org.jspecify.annotations.NonNull;
import org.springframework.stereotype.Component;

@Embeddable
public class SessionLogEntryPK
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Convert(converter=JavaUtilUuidConverter.class)
    @Column(name="sessionGuid", nullable=false, length=36)
    private UUID sessionGuid;

    public String toString() {
        return this.sessionGuid != null ? this.sessionGuid.toString() : null;
    }

    @Generated
    public SessionLogEntryPK(UUID sessionGuid) {
        this.sessionGuid = sessionGuid;
    }

    @Generated
    public SessionLogEntryPK() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionLogEntryPK)) {
            return false;
        }
        SessionLogEntryPK other = (SessionLogEntryPK)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$sessionGuid = this.getSessionGuid();
        UUID other$sessionGuid = other.getSessionGuid();
        return !(this$sessionGuid == null ? other$sessionGuid != null : !((Object)this$sessionGuid).equals(other$sessionGuid));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SessionLogEntryPK;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $sessionGuid = this.getSessionGuid();
        result = result * 59 + ($sessionGuid == null ? 43 : ((Object)$sessionGuid).hashCode());
        return result;
    }

    @Generated
    UUID getSessionGuid() {
        return this.sessionGuid;
    }

    @Component
    @Priority(value=0x3FFFFFFF)
    public static class Semantics
    extends ValueSemanticsBasedOnIdStringifierEntityAgnostic<SessionLogEntryPK> {
        public Semantics() {
            super(SessionLogEntryPK.class);
        }

        public String enstring(SessionLogEntryPK value) {
            return value.getSessionGuid().toString();
        }

        public SessionLogEntryPK destring(@NonNull String stringifiedUuid) {
            return new SessionLogEntryPK(UUID.fromString(stringifiedUuid));
        }

        public boolean isValid(@NonNull SessionLogEntryPK value) {
            return value.getSessionGuid() != null;
        }
    }
}

