/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.tabular.applib;

import jakarta.inject.Inject;
import java.util.stream.Stream;
import org.apache.causeway.core.config.beans.CausewayBeanTypeRegistry;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.core.metamodel.tabular.simple.DataTable;

public abstract class DataTableProvider {
    @Inject
    SpecificationLoader specLoader;
    @Inject
    CausewayBeanTypeRegistry beanTypeRegistry;

    public DataTable getDataTable(Class<?> domainType) {
        return DataTable.forDomainType(domainType, DataTable.columnFilterExcludingMixins().and(DataTable.columnFilterIncludingEnabledForSnapshot()));
    }

    public Stream<DataTable> streamDataTables() {
        return this.streamEntityClasses().map(this::getDataTable);
    }

    public Stream<ObjectSpecification> streamEntities() {
        return this.streamEntityClasses().map(arg_0 -> ((SpecificationLoader)this.specLoader).specForTypeElseFail(arg_0));
    }

    public Stream<Class<?>> streamEntityClasses() {
        return this.beanTypeRegistry.streamEntityTypes(this.beanTypeRegistry.persistenceStack()).sorted((a, b) -> a.getSimpleName().compareTo(b.getSimpleName()));
    }
}

