/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.commons.integration.deadlock;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import lombok.Generated;
import org.apache.causeway.core.metamodel.services.deadlock.DeadlockRecognizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.stereotype.Component;

@Component
@Priority(value=0x5FFFFFFF)
public class DeadlockRecognizerDefault
implements DeadlockRecognizer {
    @Generated
    private static final Logger log = LogManager.getLogger(DeadlockRecognizerDefault.class);
    static final String SQL_SERVER_DEADLOCK_MESSAGE = "chosen as the deadlock victim";

    public boolean isDeadlock(Throwable ex) {
        boolean whetherDeadlock;
        boolean bl = whetherDeadlock = ex instanceof DeadlockLoserDataAccessException || DeadlockRecognizerDefault.isMessage(ex, SQL_SERVER_DEADLOCK_MESSAGE);
        if (whetherDeadlock) {
            log.warn("Detected deadlock");
            log.debug("Detected deadlock details:", ex);
        }
        return whetherDeadlock;
    }

    private static boolean isMessage(Throwable ex, String message) {
        return DeadlockRecognizerDefault.isMessage(ex.getMessage(), message);
    }

    private static boolean isMessage(String exMessage, String message) {
        return exMessage != null && exMessage.contains(message);
    }

    @Inject
    @Generated
    public DeadlockRecognizerDefault() {
    }
}

