/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.exrecog;

import jakarta.annotation.Priority;
import jakarta.inject.Named;
import java.util.Optional;
import org.apache.causeway.applib.services.exceprecog.Category;
import org.apache.causeway.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.causeway.applib.services.exceprecog.Recognition;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.persistence.jdo.JdoObjectNotFoundRecognizer")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="DN6")
public class JdoObjectNotFoundRecognizer
implements ExceptionRecognizer {
    public Optional<Recognition> recognize(Throwable ex) {
        return _Exceptions.streamCausalChain((Throwable)ex).map(Object::getClass).map(Class::getSimpleName).anyMatch(exName -> exName.endsWith("ObjectNotFoundException")) ? Recognition.of((Category)Category.NOT_FOUND, (String)_Strings.nullToEmpty((String)ex.getMessage())) : Optional.empty();
    }
}

