/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.datanucleus.typeconverters.image;

import java.awt.image.BufferedImage;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.image._Images;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

public class JavaAwtBufferedImageByteArrayConverter
implements TypeConverter<BufferedImage, byte[]> {
    private static final long serialVersionUID = 5481131533536472276L;

    public byte[] toDatastoreType(BufferedImage memberValue) {
        if (memberValue == null) {
            return null;
        }
        try {
            return _Images.toBytes((BufferedImage)memberValue);
        }
        catch (Exception e) {
            throw new NucleusDataStoreException("Error serialising object of type BufferedImage to byte array", (Throwable)e);
        }
    }

    public BufferedImage toMemberType(byte[] datastoreValue) {
        if (_NullSafe.size((byte[])datastoreValue) == 0) {
            return null;
        }
        try {
            return _Images.fromBytes((byte[])datastoreValue);
        }
        catch (Exception e) {
            throw new NucleusDataStoreException("Error deserialising image datastoreValue", (Throwable)e);
        }
    }
}

