/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.facets.object.datastoreidentity;

import jakarta.inject.Inject;
import java.util.Optional;
import javax.jdo.annotations.DatastoreIdentity;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.facetapi.FacetUtil;
import org.apache.causeway.core.metamodel.facetapi.FeatureType;
import org.apache.causeway.core.metamodel.facets.FacetFactory;
import org.apache.causeway.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.datastoreidentity.JdoDatastoreIdentityFacetAnnotation;
import org.apache.causeway.persistence.jdo.provider.entities.JdoFacetContext;

public class JdoDatastoreIdentityAnnotationFacetFactory
extends FacetFactoryAbstract {
    private final JdoFacetContext jdoFacetContext;

    @Inject
    public JdoDatastoreIdentityAnnotationFacetFactory(MetaModelContext mmc, JdoFacetContext jdoFacetContext) {
        super(mmc, FeatureType.OBJECTS_ONLY);
        this.jdoFacetContext = jdoFacetContext;
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class cls = processClassContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        Optional datastoreIdentityIfAny = processClassContext.synthesizeOnType(DatastoreIdentity.class);
        FacetUtil.addFacetIfPresent(JdoDatastoreIdentityFacetAnnotation.create(datastoreIdentityIfAny, processClassContext.getFacetHolder()));
    }
}

