/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.facets.object.query;

import java.util.Objects;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.id.LogicalType;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.commons.internal.context._Context;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.spec.Hierarchical;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.core.metamodel.specloader.validator.ValidationFailure;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.query.JdoQueryAnnotationFacetFactory;
import org.apache.causeway.persistence.jdo.metamodel.facets.object.query.MetaModelValidatorForJdoqlAbstract;

class MetaModelValidatorForJdoqlFromClause
extends MetaModelValidatorForJdoqlAbstract {
    MetaModelValidatorForJdoqlFromClause(MetaModelContext mmc) {
        super(mmc, "FROM");
    }

    @Override
    String deriveClause(String query) {
        return JdoQueryAnnotationFacetFactory.from(query);
    }

    @Override
    void postInterpretJdoql(String classNameFromClause, ObjectSpecification objectSpec, String query) {
        String className = objectSpec.getCorrespondingClass().getName();
        if (Objects.equals(classNameFromClause, className)) {
            return;
        }
        Try fromSpecResult = Try.call(() -> this.getSpecificationLoader().specForType(_Context.loadClass((String)classNameFromClause)).orElse(null));
        if (!fromSpecResult.getValue().isPresent()) {
            ValidationFailure.raise((SpecificationLoader)objectSpec.getSpecificationLoader(), (Identifier)Identifier.classIdentifier((LogicalType)objectSpec.logicalType()), (String)String.format("%s: error in JDOQL query, logical type name after '%s' clause could not be loaded (JDOQL : %s)", className, this.clause, query));
            return;
        }
        ObjectSpecification fromSpec = (ObjectSpecification)fromSpecResult.getValue().get();
        Can subclasses = fromSpec.subclasses(Hierarchical.Depth.TRANSITIVE);
        if (subclasses.contains((Object)objectSpec)) {
            return;
        }
        ValidationFailure.raise((SpecificationLoader)objectSpec.getSpecificationLoader(), (Identifier)Identifier.classIdentifier((LogicalType)objectSpec.logicalType()), (String)String.format("%s: error in JDOQL query, type name after '%s' clause should be same as class name on which annotated, or one of its supertypes (JDOQL : %s)", className, this.clause, query));
    }
}

