/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.facets.prop.column;

import jakarta.inject.Inject;
import java.math.BigDecimal;
import java.util.Optional;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.IdentityType;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facetapi.FeatureType;
import org.apache.causeway.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.causeway.core.metamodel.facets.FacetFactory;
import org.apache.causeway.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.causeway.core.metamodel.facets.FacetedMethod;
import org.apache.causeway.core.metamodel.progmodel.ProgrammingModel;
import org.apache.causeway.core.metamodel.spec.feature.MixedIn;
import org.apache.causeway.persistence.commons.metamodel.facets.prop.column.BigDecimalFromXxxColumnAnnotationMetaModelRefinerUtil;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.column.MaxFractionalDigitsFacetFromJdoColumnAnnotation;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.column.MaxTotalDigitsFacetFromJdoColumnAnnotation;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.column.MinFractionalDigitsFacetFromJdoColumnAnnotation;
import org.apache.causeway.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.causeway.persistence.jdo.provider.metamodel.facets.prop.notpersistent.JdoNotPersistentFacet;

public class BigDecimalFromJdoColumnAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelRefiner {
    @Inject
    public BigDecimalFromJdoColumnAnnotationFacetFactory(MetaModelContext mmc) {
        super(mmc, FeatureType.PROPERTIES_ONLY);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        if (BigDecimal.class != processMethodContext.getMethod().getReturnType()) {
            return;
        }
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        Optional jdoColumnIfAny = processMethodContext.synthesizeOnMethod(Column.class);
        this.addFacetIfPresent(MaxTotalDigitsFacetFromJdoColumnAnnotation.create(jdoColumnIfAny, (FacetHolder)holder));
        this.addFacetIfPresent(MaxFractionalDigitsFacetFromJdoColumnAnnotation.create(jdoColumnIfAny, (FacetHolder)holder));
        if (this.getConfiguration().getValueTypes().getBigDecimal().isUseScaleForMinFractionalFacet()) {
            this.addFacetIfPresent(MinFractionalDigitsFacetFromJdoColumnAnnotation.create(jdoColumnIfAny, (FacetHolder)holder));
        }
    }

    public void refineProgrammingModel(ProgrammingModel programmingModel) {
        programmingModel.addValidatorSkipManagedBeans(objectSpec -> {
            JdoPersistenceCapableFacet pcFacet = (JdoPersistenceCapableFacet)objectSpec.getFacet(JdoPersistenceCapableFacet.class);
            if (pcFacet == null || pcFacet.getIdentityType() == IdentityType.NONDURABLE) {
                return;
            }
            objectSpec.streamProperties(MixedIn.EXCLUDED).filter(association -> !association.containsNonFallbackFacet(JdoNotPersistentFacet.class)).forEach(BigDecimalFromXxxColumnAnnotationMetaModelRefinerUtil::validateBigDecimalValueFacet);
        }, new ProgrammingModel.Marker[0]);
    }
}

