/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.facets.prop.column;

import jakarta.inject.Inject;
import java.util.Optional;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.IdentityType;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.facetapi.Facet;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facetapi.FacetUtil;
import org.apache.causeway.core.metamodel.facetapi.FeatureType;
import org.apache.causeway.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.causeway.core.metamodel.facets.FacetFactory;
import org.apache.causeway.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.causeway.core.metamodel.facets.FacetedMethod;
import org.apache.causeway.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.causeway.core.metamodel.facets.properties.property.mandatory.MandatoryFacetForPropertyAnnotation;
import org.apache.causeway.core.metamodel.progmodel.ProgrammingModel;
import org.apache.causeway.core.metamodel.spec.feature.MixedIn;
import org.apache.causeway.persistence.commons.metamodel.facets.prop.column.MandatoryFromXxxColumnAnnotationMetaModelRefinerUtil;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.column.MandatoryFacetFromAbsenceOfJdoColumnAnnotation;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.column.MandatoryFacetFromJdoColumnAnnotation;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.primarykey.MandatoryFacetFromJdoPrimaryKeyAnnotation;
import org.apache.causeway.persistence.jdo.provider.entities.JdoFacetContext;
import org.apache.causeway.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.causeway.persistence.jdo.provider.metamodel.facets.prop.notpersistent.JdoNotPersistentFacet;

public class MandatoryFromJdoColumnAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelRefiner {
    private final JdoFacetContext jdoFacetContext;

    @Inject
    public MandatoryFromJdoColumnAnnotationFacetFactory(MetaModelContext mmc, JdoFacetContext jdoFacetContext) {
        super(mmc, FeatureType.PROPERTIES_ONLY);
        this.jdoFacetContext = jdoFacetContext;
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Class cls = processMethodContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        MandatoryFacet existingFacet = (MandatoryFacet)holder.getFacet(MandatoryFacet.class);
        if (existingFacet != null) {
            if (existingFacet instanceof MandatoryFacetFromJdoPrimaryKeyAnnotation) {
                return;
            }
            if (existingFacet instanceof MandatoryFacetForPropertyAnnotation.Required) {
                return;
            }
        }
        Optional jdoColumnIfAny = processMethodContext.synthesizeOnMethod(Column.class);
        MandatoryFacet.Semantics semantics = MandatoryFromJdoColumnAnnotationFacetFactory.inferSemantics(processMethodContext, jdoColumnIfAny);
        if (jdoColumnIfAny.isPresent()) {
            FacetUtil.addFacet((Facet)new MandatoryFacetFromJdoColumnAnnotation(semantics, (FacetHolder)holder));
        } else {
            FacetUtil.addFacet((Facet)new MandatoryFacetFromAbsenceOfJdoColumnAnnotation(semantics, (FacetHolder)holder, semantics.isRequired() ? Facet.Precedence.DEFAULT : Facet.Precedence.INFERRED));
        }
    }

    static MandatoryFacet.Semantics inferSemantics(FacetFactory.ProcessMethodContext processMethodContext, Optional<Column> columnIfAny) {
        String allowsNull;
        String string = allowsNull = columnIfAny.isPresent() ? columnIfAny.get().allowsNull() : null;
        if (_Strings.isNotEmpty((CharSequence)allowsNull)) {
            return MandatoryFacet.Semantics.required((!"true".equalsIgnoreCase(allowsNull.trim()) ? 1 : 0) != 0);
        }
        Class returnType = processMethodContext.getMethod().getReturnType();
        return returnType != null && returnType.isPrimitive() ? MandatoryFacet.Semantics.REQUIRED : MandatoryFacet.Semantics.OPTIONAL;
    }

    public void refineProgrammingModel(ProgrammingModel programmingModel) {
        programmingModel.addValidatorSkipManagedBeans(objectSpec -> {
            JdoPersistenceCapableFacet pcFacet = (JdoPersistenceCapableFacet)objectSpec.getFacet(JdoPersistenceCapableFacet.class);
            if (pcFacet == null || pcFacet.getIdentityType() == IdentityType.NONDURABLE) {
                return;
            }
            objectSpec.streamProperties(MixedIn.EXCLUDED).filter(association -> !association.containsNonFallbackFacet(JdoNotPersistentFacet.class)).forEach(MandatoryFromXxxColumnAnnotationMetaModelRefinerUtil::validateMandatoryFacet);
        }, new ProgrammingModel.Marker[0]);
    }
}

