/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jdo.metamodel.facets.prop.notpersistent;

import jakarta.inject.Inject;
import jakarta.persistence.Transient;
import javax.jdo.annotations.NotPersistent;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.facetapi.Facet;
import org.apache.causeway.core.metamodel.facetapi.FacetHolder;
import org.apache.causeway.core.metamodel.facetapi.FacetUtil;
import org.apache.causeway.core.metamodel.facetapi.FeatureType;
import org.apache.causeway.core.metamodel.facets.FacetFactory;
import org.apache.causeway.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.causeway.core.metamodel.facets.FacetedMethod;
import org.apache.causeway.persistence.jdo.metamodel.facets.prop.notpersistent.JdoNotPersistentFacetFromAnnotation;
import org.apache.causeway.persistence.jdo.provider.entities.JdoFacetContext;

public class JdoNotPersistentAnnotationFacetFactory
extends FacetFactoryAbstract {
    private final JdoFacetContext jdoFacetContext;

    @Inject
    public JdoNotPersistentAnnotationFacetFactory(MetaModelContext mmc, JdoFacetContext jdoFacetContext) {
        super(mmc, FeatureType.PROPERTIES_ONLY);
        this.jdoFacetContext = jdoFacetContext;
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        if (!this.processJdoAnnotations(processMethodContext)) {
            this.processJpaAnnotations(processMethodContext);
        }
    }

    private boolean processJdoAnnotations(FacetFactory.ProcessMethodContext processMethodContext) {
        Class cls = processMethodContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return false;
        }
        NotPersistent annotation = processMethodContext.synthesizeOnMethod(NotPersistent.class).orElse(null);
        if (annotation == null) {
            return false;
        }
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new JdoNotPersistentFacetFromAnnotation((FacetHolder)facetHolder));
        return true;
    }

    private void processJpaAnnotations(FacetFactory.ProcessMethodContext processMethodContext) {
        Transient annotation = processMethodContext.synthesizeOnMethod(Transient.class).orElse(null);
        if (annotation == null) {
            return;
        }
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new JdoNotPersistentFacetFromAnnotation((FacetHolder)facetHolder));
    }
}

