/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.util.Collection;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.gen.StringUtils;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;

public class EntityUtils {
    protected String subClassName;
    protected String superClassName;
    protected String baseClassName;
    protected String subPackageName;
    protected String superPackageName;
    protected String basePackageName;
    protected DataMap primaryDataMap;
    protected ObjEntity objEntity;
    protected Collection<String> callbackNames;

    public EntityUtils(DataMap dataMap, ObjEntity objEntity, String fqnBaseClass, String fqnSuperClass, String fqnSubClass) {
        StringUtils stringUtils = StringUtils.getInstance();
        this.baseClassName = stringUtils.stripPackageName(fqnBaseClass);
        this.basePackageName = stringUtils.stripClass(fqnBaseClass);
        this.superClassName = stringUtils.stripPackageName(fqnSuperClass);
        this.superPackageName = stringUtils.stripClass(fqnSuperClass);
        this.subClassName = stringUtils.stripPackageName(fqnSubClass);
        this.subPackageName = stringUtils.stripClass(fqnSubClass);
        this.primaryDataMap = dataMap;
        this.objEntity = objEntity;
        this.callbackNames = objEntity.getCallbackMethods();
    }

    EntityUtils(DataMap dataMap, ObjEntity objEntity, String baseClassName, String basePackageName, String superClassName, String superPackageName, String subClassName, String subPackageName) {
        this.baseClassName = baseClassName;
        this.basePackageName = basePackageName;
        this.superClassName = superClassName;
        this.superPackageName = superPackageName;
        this.subClassName = subClassName;
        this.subPackageName = subPackageName;
        this.primaryDataMap = dataMap;
        this.objEntity = objEntity;
        this.callbackNames = objEntity.getCallbackMethods();
    }

    public DataMap getPrimaryDataMap() {
        return this.primaryDataMap;
    }

    public MappingNamespace getEntityResolver() {
        return this.primaryDataMap.getNamespace();
    }

    public boolean isAbstract() {
        return this.isAbstract(this.objEntity);
    }

    public boolean isAbstract(ObjEntity anObjEntity) {
        return anObjEntity != null && anObjEntity.isAbstract();
    }

    public boolean hasToManyRelationships() {
        return this.hasToManyRelationships(this.objEntity);
    }

    public boolean hasToManyRelationships(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        for (Relationship r : anObjEntity.getRelationships()) {
            if (!r.isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean hasToManyDeclaredRelationships() {
        return this.hasToManyDeclaredRelationships(this.objEntity);
    }

    public boolean hasToManyDeclaredRelationships(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        for (Relationship r : anObjEntity.getDeclaredRelationships()) {
            if (!r.isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean hasToOneRelationships() {
        return this.hasToOneRelationships(this.objEntity);
    }

    public boolean hasToOneRelationships(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        for (Relationship r : anObjEntity.getRelationships()) {
            if (r.isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean hasToOneDeclaredRelationships() {
        return this.hasToOneDeclaredRelationships(this.objEntity);
    }

    public boolean hasToOneDeclaredRelationships(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        for (Relationship r : anObjEntity.getDeclaredRelationships()) {
            if (r.isToMany()) continue;
            return true;
        }
        return false;
    }

    public String getMapKeyType(ObjRelationship relationship) {
        ObjEntity targetEntity = relationship.getTargetEntity();
        if (relationship.getMapKey() == null) {
            DbEntity dbEntity = targetEntity.getDbEntity();
            if (dbEntity != null && dbEntity.getPrimaryKeys().size() > 1) {
                return ObjectId.class.getName();
            }
            return Object.class.getName();
        }
        ObjAttribute attribute = targetEntity.getAttribute(relationship.getMapKey());
        if (attribute == null) {
            throw new CayenneRuntimeException("Invalid map key '%s', no matching attribute found", new Object[]{relationship.getMapKey()});
        }
        return attribute.getType();
    }

    public boolean declaresDbAttribute(DbAttribute pkAttribute) {
        return this.objEntity.getAttributeForDbAttribute(pkAttribute) != null;
    }

    public Collection<String> getCallbackNames() {
        return this.callbackNames;
    }
}

