/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.filters;

import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.cayenne.dbsync.reverse.filters.IncludeTableFilter;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.util.Util;

public class TableFilter {
    private final SortedSet<IncludeTableFilter> includes;
    private final SortedSet<Pattern> excludes;

    public TableFilter(SortedSet<IncludeTableFilter> includes, SortedSet<Pattern> excludes) {
        if (includes.isEmpty()) {
            throw new IllegalArgumentException("TableFilter should contain at least one IncludeTableFilter always and it is builder responsibility. If you need table filter without includes, use EmptyTableFilter");
        }
        this.includes = includes;
        this.excludes = excludes;
    }

    public boolean isIncludeTable(String tableName) {
        PatternFilter columnFilter = this.getIncludeTableColumnFilter(tableName);
        return columnFilter != null;
    }

    public PatternFilter getIncludeTableColumnFilter(String tableName) {
        IncludeTableFilter include = null;
        for (IncludeTableFilter includeTableFilter : this.includes) {
            if (includeTableFilter.pattern != null && !includeTableFilter.pattern.matcher(tableName).matches()) continue;
            include = includeTableFilter;
            break;
        }
        if (include == null) {
            return null;
        }
        for (Pattern pattern : this.excludes) {
            if (pattern == null || !pattern.matcher(tableName).matches()) continue;
            return null;
        }
        return include.columnsFilter;
    }

    public static TableFilter include(String tablePattern) {
        TreeSet<IncludeTableFilter> includes = new TreeSet<IncludeTableFilter>();
        includes.add(new IncludeTableFilter(tablePattern == null ? null : tablePattern.replaceAll("%", ".*")));
        return new TableFilter(includes, new TreeSet<Pattern>());
    }

    public static TableFilter everything() {
        TreeSet<IncludeTableFilter> includes = new TreeSet<IncludeTableFilter>();
        includes.add(new IncludeTableFilter(null));
        return new TableFilter(includes, new TreeSet<Pattern>());
    }

    protected StringBuilder toString(StringBuilder res, String prefix) {
        res.append(prefix).append("Tables: ").append("\n");
        for (IncludeTableFilter include : this.includes) {
            include.toString(res, prefix + "  ");
        }
        if (!this.excludes.isEmpty()) {
            res.append(prefix).append("  ").append(Util.join(this.excludes, (String)" OR ")).append("\n");
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableFilter)) {
            return false;
        }
        TableFilter that = (TableFilter)o;
        return this.excludes.equals(that.excludes) && this.includes.equals(that.includes);
    }

    public int hashCode() {
        int result = this.includes.hashCode();
        result = 31 * result + this.excludes.hashCode();
        return result;
    }
}

