/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.merge.DataMapMerger;
import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactoryProvider;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.AbstractToModelToken;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportAction;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportConfiguration;
import org.apache.cayenne.dbsync.reverse.dbimport.ManyToManyCandidateEntity;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.ProxyModelMergeDelegate;
import org.apache.cayenne.dbsync.reverse.filters.CatalogFilter;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.slf4j.Logger;

public class DefaultDbImportAction
implements DbImportAction {
    private final ProjectSaver projectSaver;
    private final Logger logger;
    private final DataSourceFactory dataSourceFactory;
    private final DbAdapterFactory adapterFactory;
    private final DataMapLoader mapLoader;
    private final MergerTokenFactoryProvider mergerTokenFactoryProvider;

    public DefaultDbImportAction(@Inject Logger logger, @Inject ProjectSaver projectSaver, @Inject DataSourceFactory dataSourceFactory, @Inject DbAdapterFactory adapterFactory, @Inject DataMapLoader mapLoader, @Inject MergerTokenFactoryProvider mergerTokenFactoryProvider) {
        this.logger = logger;
        this.projectSaver = projectSaver;
        this.dataSourceFactory = dataSourceFactory;
        this.adapterFactory = adapterFactory;
        this.mapLoader = mapLoader;
        this.mergerTokenFactoryProvider = mergerTokenFactoryProvider;
    }

    protected static List<MergerToken> sort(List<MergerToken> reverse) {
        Collections.sort(reverse);
        return reverse;
    }

    public static void flattenManyToManyRelationships(DataMap map, Collection<ObjEntity> loadedObjEntities, ObjectNameGenerator objectNameGenerator) {
        if (loadedObjEntities.isEmpty()) {
            return;
        }
        LinkedList<ObjEntity> entitiesForDelete = new LinkedList<ObjEntity>();
        for (ObjEntity curEntity : loadedObjEntities) {
            ManyToManyCandidateEntity entity = ManyToManyCandidateEntity.build(curEntity);
            if (entity == null) continue;
            entity.optimizeRelationships(objectNameGenerator);
            entitiesForDelete.add(curEntity);
        }
        for (ObjEntity curDeleteEntity : entitiesForDelete) {
            map.removeObjEntity(curDeleteEntity.getName(), true);
        }
        loadedObjEntities.removeAll(entitiesForDelete);
    }

    @Override
    public void execute(DbImportConfiguration config) throws Exception {
        DataMap sourceDataMap;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DB connection: " + config.getDataSourceInfo());
            this.logger.debug(String.valueOf(config));
        }
        boolean hasChanges = false;
        DataNodeDescriptor dataNodeDescriptor = config.createDataNodeDescriptor();
        DataSource dataSource = this.dataSourceFactory.getDataSource(dataNodeDescriptor);
        DbAdapter adapter = this.adapterFactory.createAdapter(dataNodeDescriptor, dataSource);
        try (Connection connection = dataSource.getConnection();){
            sourceDataMap = this.load(config, adapter, connection);
        }
        DataMap targetDataMap = this.existingTargetMap(config);
        if (targetDataMap == null) {
            String path = config.getTargetDataMap() == null ? "null" : config.getTargetDataMap().getAbsolutePath() + "'";
            this.logger.info("");
            this.logger.info("Map file does not exist. Loaded db model will be saved into '" + path);
            hasChanges = true;
            targetDataMap = this.newTargetDataMap(config);
        }
        this.transformSourceBeforeMerge(sourceDataMap, targetDataMap, config);
        MergerTokenFactory mergerTokenFactory = (MergerTokenFactory)this.mergerTokenFactoryProvider.get(adapter);
        DbLoaderConfiguration loaderConfig = config.getDbLoaderConfig();
        Collection<MergerToken> tokens = DataMapMerger.builder(mergerTokenFactory).filters(loaderConfig.getFiltersConfig()).skipPKTokens(loaderConfig.isSkipPrimaryKeyLoading()).skipRelationshipsTokens(loaderConfig.isSkipRelationshipsLoading()).build().createMergeTokens(targetDataMap, sourceDataMap);
        tokens = this.log(DefaultDbImportAction.sort(this.reverse(mergerTokenFactory, tokens)));
        hasChanges |= this.syncDataMapProperties(targetDataMap, config);
        hasChanges |= this.applyTokens(targetDataMap, tokens, config);
        if (hasChanges |= this.syncProcedures(targetDataMap, sourceDataMap, loaderConfig.getFiltersConfig())) {
            this.saveLoaded(targetDataMap);
        }
    }

    protected void transformSourceBeforeMerge(DataMap sourceDataMap, DataMap targetDataMap, DbImportConfiguration configuration) {
        if (configuration.isForceDataMapCatalog()) {
            String catalog = targetDataMap.getDefaultCatalog();
            for (DbEntity e : sourceDataMap.getDbEntities()) {
                e.setCatalog(catalog);
            }
        }
        if (configuration.isForceDataMapSchema()) {
            String schema = targetDataMap.getDefaultSchema();
            for (DbEntity e : sourceDataMap.getDbEntities()) {
                e.setSchema(schema);
            }
        }
    }

    private boolean syncDataMapProperties(DataMap targetDataMap, DbImportConfiguration config) {
        String defaultPackage = config.getDefaultPackage();
        if (defaultPackage == null || defaultPackage.trim().length() == 0) {
            return false;
        }
        if (defaultPackage.equals(targetDataMap.getDefaultPackage())) {
            return false;
        }
        targetDataMap.setDefaultPackage(defaultPackage);
        return true;
    }

    private void relationshipsSanity(DataMap executed) {
        for (ObjEntity objEntity : executed.getObjEntities()) {
            LinkedList rels = new LinkedList(objEntity.getRelationships());
            for (ObjRelationship rel : rels) {
                if (rel.getSourceEntity() != null && rel.getTargetEntity() != null) continue;
                this.logger.error("Incorrect obj relationship source or target entity is null: " + rel);
                objEntity.removeRelationship(rel.getName());
            }
        }
    }

    private Collection<MergerToken> log(List<MergerToken> tokens) {
        this.logger.info("");
        if (tokens.isEmpty()) {
            this.logger.info("Detected changes: No changes to import.");
            return tokens;
        }
        this.logger.info("Detected changes: ");
        for (MergerToken token : tokens) {
            this.logger.info(String.format("    %-20s %s", token.getTokenName(), token.getTokenValue()));
        }
        this.logger.info("");
        return tokens;
    }

    protected DataMap existingTargetMap(DbImportConfiguration configuration) throws IOException {
        File file = configuration.getTargetDataMap();
        if (file != null && file.exists() && file.canRead()) {
            URLResource configurationResource = new URLResource(file.toURI().toURL());
            DataMap dataMap = this.mapLoader.load((Resource)configurationResource);
            dataMap.setNamespace((MappingNamespace)new EntityResolver(Collections.singleton(dataMap)));
            dataMap.setConfigurationSource((Resource)configurationResource);
            return dataMap;
        }
        return null;
    }

    protected DataMap newTargetDataMap(DbImportConfiguration config) throws IOException {
        CatalogFilter[] catalogs;
        DataMap dataMap = new DataMap();
        dataMap.setName(config.getDataMapName());
        dataMap.setConfigurationSource((Resource)new URLResource(config.getTargetDataMap().toURI().toURL()));
        dataMap.setNamespace((MappingNamespace)new EntityResolver(Collections.singleton(dataMap)));
        String defaultPackage = config.getDefaultPackage();
        if (defaultPackage != null && defaultPackage.length() > 0) {
            dataMap.setDefaultPackage(defaultPackage);
        }
        if ((catalogs = config.getDbLoaderConfig().getFiltersConfig().getCatalogs()).length > 0) {
            String schema;
            String catalog = catalogs[0].name;
            if (catalog != null && catalog.length() > 0 && catalog.indexOf(37) < 0) {
                dataMap.setDefaultCatalog(catalog);
            }
            if ((schema = catalogs[0].schemas[0].name) != null && schema.length() > 0 && schema.indexOf(37) < 0) {
                dataMap.setDefaultSchema(schema);
            }
        }
        return dataMap;
    }

    private List<MergerToken> reverse(MergerTokenFactory mergerTokenFactory, Iterable<MergerToken> mergeTokens) throws IOException {
        LinkedList<MergerToken> tokens = new LinkedList<MergerToken>();
        for (MergerToken token : mergeTokens) {
            if (token instanceof AbstractToModelToken) continue;
            tokens.add(token.createReverse(mergerTokenFactory));
        }
        return tokens;
    }

    private boolean applyTokens(DataMap targetDataMap, Collection<MergerToken> tokens, DbImportConfiguration config) {
        if (tokens.isEmpty()) {
            this.logger.info("");
            this.logger.info("Detected changes: No changes to import.");
            return false;
        }
        final LinkedList<ObjEntity> loadedObjEntities = new LinkedList<ObjEntity>();
        ProxyModelMergeDelegate mergeDelegate = new ProxyModelMergeDelegate(config.createMergeDelegate()){

            @Override
            public void objEntityAdded(ObjEntity ent) {
                loadedObjEntities.add(ent);
                super.objEntityAdded(ent);
            }
        };
        ObjectNameGenerator nameGenerator = config.createNameGenerator();
        MergerContext mergerContext = MergerContext.builder(targetDataMap).delegate(mergeDelegate).nameGenerator(nameGenerator).usingPrimitives(config.isUsePrimitives()).usingJava7Types(config.isUseJava7Types()).meaningfulPKFilter(config.createMeaningfulPKFilter()).build();
        for (MergerToken token : tokens) {
            try {
                token.execute(mergerContext);
            }
            catch (Throwable th) {
                String message = "Migration Error. Can't apply changes from token: " + token.getTokenName() + " (" + token.getTokenValue() + ")";
                this.logger.error(message, th);
                mergerContext.getValidationResult().addFailure((ValidationFailure)new SimpleValidationFailure((Object)th, (Object)message));
            }
        }
        ValidationResult failures = mergerContext.getValidationResult();
        if (failures.hasFailures()) {
            this.logger.info("Migration Complete.");
            this.logger.warn("Migration finished. The following problem(s) were encountered and ignored.");
            for (ValidationFailure failure : failures.getFailures()) {
                this.logger.warn(failure.toString());
            }
        } else {
            this.logger.info("Migration Complete Successfully.");
        }
        DefaultDbImportAction.flattenManyToManyRelationships(targetDataMap, loadedObjEntities, nameGenerator);
        this.relationshipsSanity(targetDataMap);
        return true;
    }

    private boolean syncProcedures(DataMap targetDataMap, DataMap loadedDataMap, FiltersConfig filters) {
        Collection procedures = loadedDataMap.getProcedures();
        if (procedures.isEmpty()) {
            return false;
        }
        boolean hasChanges = false;
        for (Procedure procedure : procedures) {
            PatternFilter proceduresFilter = filters.proceduresFilter(procedure.getCatalog(), procedure.getSchema());
            if (proceduresFilter == null || !proceduresFilter.isIncluded(procedure.getName())) continue;
            Procedure oldProcedure = targetDataMap.getProcedure(procedure.getName());
            if (oldProcedure != null) {
                targetDataMap.removeProcedure(procedure.getName());
                this.logger.info("Replace procedure " + procedure.getName());
            } else {
                this.logger.info("Add new procedure " + procedure.getName());
            }
            targetDataMap.addProcedure(procedure);
            hasChanges = true;
        }
        return hasChanges;
    }

    protected void saveLoaded(DataMap dataMap) throws FileNotFoundException {
        ConfigurationTree projectRoot = new ConfigurationTree((ConfigurationNode)dataMap);
        Project project = new Project(projectRoot);
        this.projectSaver.save(project);
    }

    protected DataMap load(DbImportConfiguration config, DbAdapter adapter, Connection connection) throws Exception {
        return this.createDbLoader(adapter, connection, config).load();
    }

    protected DbLoader createDbLoader(DbAdapter adapter, Connection connection, DbImportConfiguration config) {
        return new DbLoader(adapter, connection, config.getDbLoaderConfig(), config.createLoaderDelegate(), config.createNameGenerator());
    }
}

