/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.SchemaContainer;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class ReverseEngineering
extends SchemaContainer
implements Serializable,
XMLSerializable {
    private boolean skipRelationshipsLoading;
    private boolean skipPrimaryKeyLoading;
    private String defaultPackage;
    private boolean forceDataMapCatalog;
    private boolean forceDataMapSchema;
    private String meaningfulPkTables;
    private String namingStrategy = "org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator";
    private String stripFromTableNames = "";
    private boolean usePrimitives = true;
    private boolean useJava7Types = false;
    private final List<String> tableTypes = new ArrayList<String>();
    private final List<Catalog> catalogCollection = new ArrayList<Catalog>();

    public ReverseEngineering() {
    }

    public ReverseEngineering(ReverseEngineering original) {
        super(original);
        this.setDefaultPackage(original.getDefaultPackage());
        this.setStripFromTableNames(original.getStripFromTableNames());
        this.setNamingStrategy(original.getNamingStrategy());
        this.setMeaningfulPkTables(original.getMeaningfulPkTables());
        this.setSkipPrimaryKeyLoading(original.getSkipPrimaryKeyLoading());
        this.setSkipRelationshipsLoading(original.getSkipRelationshipsLoading());
        this.setForceDataMapSchema(original.isForceDataMapSchema());
        this.setForceDataMapCatalog(original.isForceDataMapCatalog());
        this.setUseJava7Types(original.isUseJava7Types());
        this.setUsePrimitives(original.isUsePrimitives());
        this.setTableTypes(Arrays.asList(original.getTableTypes()));
        this.setName(original.getName());
        for (Catalog catalog : original.getCatalogs()) {
            this.addCatalog(new Catalog(catalog));
        }
    }

    public Boolean getSkipRelationshipsLoading() {
        return this.skipRelationshipsLoading;
    }

    public void setSkipRelationshipsLoading(Boolean skipRelationshipsLoading) {
        this.skipRelationshipsLoading = skipRelationshipsLoading;
    }

    public Boolean getSkipPrimaryKeyLoading() {
        return this.skipPrimaryKeyLoading;
    }

    public void setSkipPrimaryKeyLoading(Boolean skipPrimaryKeyLoading) {
        this.skipPrimaryKeyLoading = skipPrimaryKeyLoading;
    }

    public List<Catalog> getCatalogs() {
        return this.catalogCollection;
    }

    public String[] getTableTypes() {
        return this.tableTypes.toArray(new String[this.tableTypes.size()]);
    }

    public Collection<String> getTableTypesCollection() {
        return this.tableTypes;
    }

    public void setTableTypes(Collection<String> tableTypes) {
        this.tableTypes.addAll(tableTypes);
    }

    public void addTableType(String type) {
        this.tableTypes.add(type);
    }

    public void addCatalog(Catalog catalog) {
        this.catalogCollection.add(catalog);
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("ReverseEngineering: ").append("\n");
        if (!ReverseEngineering.isBlank(this.catalogCollection)) {
            for (Catalog catalog : this.catalogCollection) {
                catalog.toString(res, "  ");
            }
        }
        super.toString(res, "  ");
        if (this.skipRelationshipsLoading) {
            res.append("\n  Skip Relationships Loading");
        }
        if (this.skipPrimaryKeyLoading) {
            res.append("\n  Skip PrimaryKey Loading");
        }
        if (this.forceDataMapCatalog) {
            res.append("\n  Force DataMap catalog");
        }
        if (this.forceDataMapSchema) {
            res.append("\n  Force DataMap schema");
        }
        if (this.usePrimitives) {
            res.append("\n  Use primitives");
        }
        if (this.useJava7Types) {
            res.append("\n  Use Java 7 types");
        }
        return res.toString();
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public boolean isForceDataMapCatalog() {
        return this.forceDataMapCatalog;
    }

    public boolean isForceDataMapSchema() {
        return this.forceDataMapSchema;
    }

    public String getMeaningfulPkTables() {
        return this.meaningfulPkTables;
    }

    public String getNamingStrategy() {
        return this.namingStrategy;
    }

    public String getStripFromTableNames() {
        return this.stripFromTableNames;
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public boolean isUseJava7Types() {
        return this.useJava7Types;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public void setForceDataMapCatalog(boolean forceDataMapCatalog) {
        this.forceDataMapCatalog = forceDataMapCatalog;
    }

    public void setForceDataMapSchema(boolean forceDataMapSchema) {
        this.forceDataMapSchema = forceDataMapSchema;
    }

    public void setMeaningfulPkTables(String meaningfulPkTables) {
        this.meaningfulPkTables = meaningfulPkTables;
    }

    public void setNamingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setStripFromTableNames(String stripFromTableNames) {
        this.stripFromTableNames = stripFromTableNames;
    }

    public void setUsePrimitives(boolean usePrimitives) {
        this.usePrimitives = usePrimitives;
    }

    public void setUseJava7Types(boolean useJava7Types) {
        this.useJava7Types = useJava7Types;
    }

    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("dbImport").attribute("xmlns", "http://cayenne.apache.org/schema/10/dbimport").nested(this.getIncludeTables(), delegate).nested(this.getExcludeTables(), delegate).nested(this.getIncludeColumns(), delegate).nested(this.getExcludeColumns(), delegate).nested(this.getIncludeProcedures(), delegate).nested(this.getExcludeProcedures(), delegate).nested(this.getCatalogs(), delegate).nested(this.getSchemas(), delegate);
        String[] tableTypes = this.getTableTypes();
        if (tableTypes.length != 0) {
            encoder.start("tableTypes");
            for (String type : tableTypes) {
                encoder.simpleTag("tableType", type);
            }
            encoder.end();
        }
        encoder.simpleTag("defaultPackage", this.getDefaultPackage()).simpleTag("forceDataMapCatalog", Boolean.toString(this.isForceDataMapCatalog())).simpleTag("forceDataMapSchema", Boolean.toString(this.isForceDataMapSchema())).simpleTag("meaningfulPkTables", this.getMeaningfulPkTables()).simpleTag("namingStrategy", this.getNamingStrategy()).simpleTag("skipPrimaryKeyLoading", this.getSkipPrimaryKeyLoading().toString()).simpleTag("skipRelationshipsLoading", this.getSkipRelationshipsLoading().toString()).simpleTag("stripFromTableNames", this.getStripFromTableNames()).simpleTag("useJava7Types", Boolean.toString(this.isUseJava7Types())).simpleTag("usePrimitives", Boolean.toString(this.isUsePrimitives())).end();
    }
}

