/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.Scope;
import org.apache.cayenne.di.UnorderedListBuilder;
import org.apache.cayenne.di.spi.Binding;
import org.apache.cayenne.di.spi.ConstructorInjectingProvider;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.FieldInjectingProvider;
import org.apache.cayenne.di.spi.InstanceProvider;
import org.apache.cayenne.di.spi.ListProvider;

class DefaultListBuilder<T>
implements ListBuilder<T> {
    protected static AtomicLong incrementer = new AtomicLong();
    protected DefaultInjector injector;
    protected Key<List<?>> bindingKey;

    DefaultListBuilder(Key<List<?>> bindingKey, DefaultInjector injector) {
        this.injector = injector;
        this.bindingKey = bindingKey;
        this.getListProvider();
    }

    @Override
    public ListBuilder<T> add(Class<? extends T> interfaceType) throws DIRuntimeException {
        Key<? extends T> key = Key.get(interfaceType);
        Binding<T> binding = this.injector.getBinding(key);
        if (binding == null) {
            return this.addWithBinding(interfaceType);
        }
        this.getListProvider().add(key, binding.getScoped());
        return this;
    }

    <K extends T> ListBuilder<T> addWithBinding(Class<K> interfaceType) {
        Key<K> key = Key.get(interfaceType);
        ConstructorInjectingProvider<K> provider0 = new ConstructorInjectingProvider<K>(interfaceType, this.injector);
        FieldInjectingProvider<K> provider1 = new FieldInjectingProvider<K>(provider0, this.injector);
        this.injector.putBinding(key, provider1);
        this.getListProvider().add(key, this.injector.getProvider(key));
        return this;
    }

    @Override
    public ListBuilder<T> add(T object) throws DIRuntimeException {
        InstanceProvider<T> provider0 = new InstanceProvider<T>(object);
        FieldInjectingProvider<T> provider1 = new FieldInjectingProvider<T>(provider0, this.injector);
        this.getListProvider().add(Key.get(object.getClass(), String.valueOf(incrementer.getAndIncrement())), provider1);
        return this;
    }

    @Override
    public ListBuilder<T> add(Key<T> key, T object) throws DIRuntimeException {
        InstanceProvider<T> provider0 = new InstanceProvider<T>(object);
        FieldInjectingProvider<T> provider1 = new FieldInjectingProvider<T>(provider0, this.injector);
        this.getListProvider().add(key, provider1);
        return this;
    }

    @Override
    public UnorderedListBuilder<T> after(Class<?> type) {
        return this.after(Key.get(type));
    }

    @Override
    public UnorderedListBuilder<T> after(Key<?> key) {
        this.getListProvider().after(key);
        return this;
    }

    @Override
    public UnorderedListBuilder<T> before(Class<?> type) {
        return this.before(Key.get(type));
    }

    @Override
    public UnorderedListBuilder<T> before(Key<?> key) {
        this.getListProvider().before(key);
        return this;
    }

    @Override
    public ListBuilder<T> addAll(Collection<T> objects) throws DIRuntimeException {
        LinkedHashMap keyProviderMap = new LinkedHashMap();
        for (T object : objects) {
            InstanceProvider<T> provider0 = new InstanceProvider<T>(object);
            FieldInjectingProvider<T> provider1 = new FieldInjectingProvider<T>(provider0, this.injector);
            keyProviderMap.put(Key.get(object.getClass(), String.valueOf(incrementer.getAndIncrement())), provider1);
        }
        this.getListProvider().addAll(keyProviderMap);
        return this;
    }

    private ListProvider getListProvider() {
        ListProvider provider = null;
        Binding<List<?>> binding = this.injector.getBinding(this.bindingKey);
        if (binding == null) {
            provider = new ListProvider();
            this.injector.putBinding(this.bindingKey, provider);
        } else {
            provider = (ListProvider)binding.getOriginal();
        }
        return provider;
    }

    @Override
    public void in(Scope scope) {
        this.injector.changeBindingScope(this.bindingKey, scope);
    }
}

