/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.DIGraph;

class ListProvider
implements Provider<List<?>> {
    private Map<Key<?>, Provider<?>> providers = new HashMap();
    private DIGraph<Key<?>> graph = new DIGraph();
    private Key<?> lastKey;
    private Collection<Key<?>> lastKeys = Collections.emptySet();

    @Override
    public List<?> get() throws DIRuntimeException {
        List<Key<?>> insertOrder = this.graph.topSort();
        if (insertOrder.size() != this.providers.size()) {
            ArrayList emptyKeys = new ArrayList();
            for (Key<?> key : insertOrder) {
                if (this.providers.containsKey(key)) continue;
                emptyKeys.add(key);
            }
            throw new DIRuntimeException("DI list has no providers for keys: %s", emptyKeys);
        }
        ArrayList list = new ArrayList(insertOrder.size());
        for (Key<?> key : insertOrder) {
            list.add(this.providers.get(key).get());
        }
        return list;
    }

    void add(Key<?> key, Provider<?> provider) {
        this.providers.put(key, provider);
        this.graph.add(key);
        this.lastKey = key;
        this.lastKeys.clear();
    }

    void addAll(Map<Key<?>, Provider<?>> keyProviderMap) {
        this.providers.putAll(keyProviderMap);
        this.graph.addAll(keyProviderMap.keySet());
        this.lastKeys = keyProviderMap.keySet();
    }

    void after(Key<?> after) {
        if (!this.lastKeys.isEmpty()) {
            for (Key<?> key : this.lastKeys) {
                this.graph.add(key, after);
            }
            return;
        }
        this.graph.add(this.lastKey, after);
    }

    void before(Key<?> before) {
        if (!this.lastKeys.isEmpty()) {
            for (Key<?> key : this.lastKeys) {
                this.graph.add(before, key);
            }
            return;
        }
        this.graph.add(before, this.lastKey);
    }
}

