/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.InputStream;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.conf.ClasspathResourceFinder;
import org.apache.cayenne.conf.ConfigLoader;
import org.apache.cayenne.conf.ConfigLoaderDelegate;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.ResourceFinder;
import org.apache.cayenne.conf.RuntimeLoadDelegate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiProjectConfiguration
extends Configuration {
    private static final Log logger = LogFactory.getLog(MultiProjectConfiguration.class);
    protected ResourceFinder resourceFinder = new ClasspathResourceFinder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        logger.debug((Object)"loading configuration");
        InputStream in = this.getDomainConfiguration();
        if (in == null) {
            StringBuilder msg = new StringBuilder();
            msg.append("[").append(this.getClass().getName()).append("] : Domain configuration file \"").append(this.getDomainConfigurationName()).append("\" is not found.");
            throw new ConfigurationException(msg.toString());
        }
        ConfigLoaderDelegate delegate = this.getLoaderDelegate();
        if (delegate == null) {
            delegate = new RuntimeLoadDelegate(this, this.getLoadStatus());
        }
        ConfigLoader loader = new ConfigLoader(delegate);
        try {
            loader.loadDomains(in);
        }
        finally {
            this.setLoadStatus(delegate.getStatus());
            in.close();
        }
        logger.debug((Object)"initialize finished.");
    }

    protected ResourceFinder getResourceFinder() {
        return this.resourceFinder;
    }
}

