/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collection;
import java.util.HashSet;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.merge.MergeDirection;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.util.EntityMergeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToModelToken
implements MergerToken {
    @Override
    public final MergeDirection getDirection() {
        return MergeDirection.TO_MODEL;
    }

    protected void synchronizeWithObjEntity(MergerContext mergerContext, DbEntity entity) {
        for (ObjEntity objEntity : this.objEntitiesMappedToDbEntity(entity)) {
            new EntityMergeSupport(objEntity.getDataMap()).synchronizeWithDbEntity(objEntity);
        }
    }

    protected Collection<ObjEntity> objEntitiesMappedToDbEntity(DbEntity entity) {
        HashSet<ObjEntity> objEntities = new HashSet<ObjEntity>();
        MappingNamespace mns = entity.getDataMap().getNamespace();
        for (ObjEntity objEntity : mns.getObjEntities()) {
            if (objEntity.getDbEntity() == null || !objEntity.getDbEntity().equals(entity)) continue;
            objEntities.add(objEntity);
        }
        return objEntities;
    }

    protected void remove(MergerContext mergerContext, DbRelationship rel, boolean reverse) {
        if (rel == null) {
            return;
        }
        if (reverse) {
            this.remove(mergerContext, rel.getReverseRelationship(), false);
        }
        DbEntity dbEntity = (DbEntity)rel.getSourceEntity();
        for (ObjEntity objEntity : this.objEntitiesMappedToDbEntity(dbEntity)) {
            this.remove(mergerContext, objEntity.getRelationshipForDbRelationship(rel), true);
        }
        rel.getSourceEntity().removeRelationship(rel.getName());
        mergerContext.getModelMergeDelegate().dbRelationshipRemoved(rel);
    }

    protected void remove(MergerContext mergerContext, ObjRelationship rel, boolean reverse) {
        if (rel == null) {
            return;
        }
        if (reverse) {
            this.remove(mergerContext, rel.getReverseRelationship(), false);
        }
        rel.getSourceEntity().removeRelationship(rel.getName());
        mergerContext.getModelMergeDelegate().objRelationshipRemoved(rel);
    }

    public String toString() {
        StringBuilder ts = new StringBuilder();
        ts.append(this.getTokenName());
        ts.append(' ');
        ts.append(this.getTokenValue());
        ts.append(' ');
        ts.append((Object)this.getDirection());
        return ts.toString();
    }

    static abstract class EntityAndColumn
    extends Entity {
        private DbAttribute column;

        public EntityAndColumn(DbEntity entity, DbAttribute column) {
            super(entity);
            this.column = column;
        }

        public DbAttribute getColumn() {
            return this.column;
        }

        public String getTokenValue() {
            return this.getEntity().getName() + "." + this.getColumn().getName();
        }
    }

    static abstract class Entity
    extends AbstractToModelToken {
        private DbEntity entity;

        public Entity(DbEntity entity) {
            this.entity = entity;
        }

        public DbEntity getEntity() {
            return this.entity;
        }

        public String getTokenValue() {
            return this.getEntity().getName();
        }
    }
}

