/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.event.DataContextEvent;
import org.apache.cayenne.access.event.DataContextTransactionEventListener;
import org.apache.cayenne.access.event.DataObjectTransactionEventListener;
import org.apache.cayenne.event.EventManager;

class DataContextFlushEventHandler
implements DataContextTransactionEventListener {
    List objectsToNotify;
    DataContext originatingContext;

    DataContextFlushEventHandler(DataContext originatingContext) {
        this.originatingContext = originatingContext;
        this.objectsToNotify = new ArrayList();
        Iterator it = originatingContext.getObjectStore().getObjectIterator();
        while (it.hasNext()) {
            Persistent object = (Persistent)it.next();
            if (!(object instanceof DataObjectTransactionEventListener)) continue;
            switch (object.getPersistenceState()) {
                case 2: 
                case 4: 
                case 6: {
                    this.objectsToNotify.add(object);
                }
            }
        }
    }

    void registerForDataContextEvents() {
        EventManager eventManager = this.originatingContext.getEventManager();
        eventManager.addListener(this, "dataContextWillCommit", DataContextEvent.class, DataContext.WILL_COMMIT, this.originatingContext);
        eventManager.addListener(this, "dataContextDidCommit", DataContextEvent.class, DataContext.DID_COMMIT, this.originatingContext);
        eventManager.addListener(this, "dataContextDidRollback", DataContextEvent.class, DataContext.DID_ROLLBACK, this.originatingContext);
    }

    void unregisterFromDataContextEvents() {
        EventManager eventManager = this.originatingContext.getEventManager();
        eventManager.removeListener(this, DataContext.WILL_COMMIT);
        eventManager.removeListener(this, DataContext.DID_COMMIT);
        eventManager.removeListener(this, DataContext.DID_ROLLBACK);
    }

    public void dataContextWillCommit(DataContextEvent event) {
        Iterator iter = this.objectsToNotify.iterator();
        while (iter.hasNext()) {
            ((DataObjectTransactionEventListener)iter.next()).willCommit(event);
        }
    }

    public void dataContextDidCommit(DataContextEvent event) {
        Iterator iter = this.objectsToNotify.iterator();
        while (iter.hasNext()) {
            ((DataObjectTransactionEventListener)iter.next()).didCommit(event);
        }
    }

    public void dataContextDidRollback(DataContextEvent event) {
    }
}

