/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataContextDelegate;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.DataRowUtils;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.ObjectStoreGraphDiff;
import org.apache.cayenne.access.event.SnapshotEvent;
import org.apache.cayenne.access.event.SnapshotEventListener;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.graph.NodeCreateOperation;
import org.apache.cayenne.graph.NodeDeleteOperation;
import org.apache.cayenne.graph.NodeDiff;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SQLResultSetMapping;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.commons.collections.map.ReferenceMap;

public class ObjectStore
implements Serializable,
SnapshotEventListener,
GraphManager {
    protected Map objectMap;
    protected Map changes;
    int currentDiffId;
    protected transient DataRowStore dataRowCache;
    private boolean dataRowCacheSet;
    protected DataContext context;

    static Map createObjectMap() {
        return new ReferenceMap(0, 2);
    }

    public ObjectStore() {
        this(null);
    }

    public ObjectStore(DataRowStore dataRowCache) {
        this(dataRowCache, null);
    }

    public ObjectStore(DataRowStore dataRowCache, Map objectMap) {
        this.setDataRowCache(dataRowCache);
        this.objectMap = objectMap != null ? objectMap : ObjectStore.createObjectMap();
        this.changes = new HashMap();
    }

    synchronized ObjectDiff registerDiff(Object nodeId, NodeDiff diff) {
        ObjectDiff objectDiff;
        if (diff != null) {
            diff.setDiffId(++this.currentDiffId);
        }
        if ((objectDiff = (ObjectDiff)this.changes.get(nodeId)) == null) {
            Persistent object = (Persistent)this.objectMap.get(nodeId);
            if (object.getPersistenceState() == 3) {
                object.setPersistenceState(4);
                if (object instanceof DataObject) {
                    DataContextDelegate delegate;
                    DataObject dataObject = (DataObject)object;
                    DataRow snapshot = this.getCachedSnapshot((ObjectId)nodeId);
                    if (snapshot != null && snapshot.getVersion() != dataObject.getSnapshotVersion() && (delegate = this.context.nonNullDelegate()).shouldMergeChanges(dataObject, snapshot)) {
                        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
                        DataRowUtils.forceMergeWithSnapshot(this.context, descriptor, dataObject, snapshot);
                        dataObject.setSnapshotVersion(snapshot.getVersion());
                        delegate.finishedMergeChanges(dataObject);
                    }
                }
            }
            objectDiff = new ObjectDiff(object);
            objectDiff.setDiffId(++this.currentDiffId);
            this.changes.put(nodeId, objectDiff);
        }
        if (diff != null) {
            objectDiff.addDiff(diff);
        }
        return objectDiff;
    }

    public int registeredObjectsCount() {
        return this.objectMap.size();
    }

    public int cachedQueriesCount() {
        return this.context != null && this.context.queryCache != null ? this.context.queryCache.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRowStore getDataRowCache() {
        if (this.dataRowCache == null && this.context != null && this.dataRowCacheSet) {
            ObjectStore objectStore = this;
            synchronized (objectStore) {
                DataDomain domain;
                if (this.dataRowCache == null && (domain = this.context.getParentDataDomain()) != null) {
                    this.setDataRowCache(domain.getSharedSnapshotCache());
                }
            }
        }
        return this.dataRowCache;
    }

    public void setDataRowCache(DataRowStore dataRowCache) {
        if (dataRowCache == this.dataRowCache) {
            return;
        }
        if (this.dataRowCache != null && dataRowCache.getEventManager() != null) {
            dataRowCache.getEventManager().removeListener(this, this.dataRowCache.getSnapshotEventSubject());
        }
        this.dataRowCache = dataRowCache;
        if (dataRowCache != null && dataRowCache.getEventManager() != null) {
            dataRowCache.getEventManager().addNonBlockingListener(this, "snapshotsChanged", SnapshotEvent.class, dataRowCache.getSnapshotEventSubject(), dataRowCache);
        }
        this.dataRowCacheSet = dataRowCache != null;
    }

    public synchronized void objectsInvalidated(Collection objects) {
        if (this.context != null) {
            this.context.invalidateObjects(objects);
        }
    }

    public synchronized void objectsUnregistered(Collection objects) {
        if (objects.isEmpty()) {
            return;
        }
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>(objects.size());
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Persistent object = (Persistent)it.next();
            ObjectId id = object.getObjectId();
            this.objectMap.remove(id);
            this.changes.remove(id);
            ids.add(id);
            object.setObjectContext(null);
            object.setObjectId(null);
            object.setPersistenceState(1);
        }
        if (this.getDataRowCache() != null) {
            this.getDataRowCache().processSnapshotChanges(this, Collections.EMPTY_MAP, Collections.EMPTY_LIST, ids, Collections.EMPTY_LIST);
        }
    }

    public synchronized void objectsRolledBack() {
        Iterator it = this.getObjectIterator();
        while (it.hasNext()) {
            Persistent object = (Persistent)it.next();
            int objectState = object.getPersistenceState();
            switch (objectState) {
                case 2: {
                    it.remove();
                    object.setObjectContext(null);
                    object.setObjectId(null);
                    object.setPersistenceState(1);
                    break;
                }
                case 4: 
                case 6: {
                    object.setPersistenceState(5);
                    break;
                }
            }
        }
        this.changes = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshotsUpdatedForObjects(List objects, List snapshots, boolean refresh) {
        DataRowStore cache = this.getDataRowCache();
        if (cache != null) {
            ObjectStore objectStore = this;
            synchronized (objectStore) {
                cache.snapshotsUpdatedForObjects(objects, snapshots, refresh);
            }
        }
    }

    ObjectStoreGraphDiff getChanges() {
        return new ObjectStoreGraphDiff(this);
    }

    Map getChangesByObjectId() {
        return this.changes;
    }

    void postprocessAfterPhantomCommit() {
        Iterator it = this.changes.keySet().iterator();
        while (it.hasNext()) {
            ObjectId id = (ObjectId)it.next();
            Persistent object = (Persistent)this.objectMap.get(id);
            object.setPersistenceState(3);
        }
        this.changes.clear();
    }

    void postprocessAfterCommit(GraphDiff parentChanges) {
        Iterator entries = this.objectMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Persistent object = (Persistent)entry.getValue();
            switch (object.getPersistenceState()) {
                case 6: {
                    entries.remove();
                    object.setObjectContext(null);
                    object.setPersistenceState(1);
                    break;
                }
                case 2: 
                case 4: {
                    object.setPersistenceState(3);
                }
            }
        }
        if (!parentChanges.isNoop()) {
            parentChanges.apply(new GraphChangeHandler(){

                public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
                }

                public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
                }

                public void nodeCreated(Object nodeId) {
                }

                public void nodeIdChanged(Object nodeId, Object newId) {
                    ObjectStore.this.processIdChange(nodeId, newId);
                }

                public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
                }

                public void nodeRemoved(Object nodeId) {
                }
            });
        }
        this.changes = new HashMap();
    }

    public synchronized void startTrackingNewObjects() {
    }

    public synchronized void unregisterNewObjects() {
    }

    public DataRow getCachedSnapshot(ObjectId oid) {
        if (this.context != null && this.context.getChannel() != null) {
            CachedSnapshotQuery query = new CachedSnapshotQuery(oid);
            List results = this.context.getChannel().onQuery(this.context, query).firstList();
            return results.isEmpty() ? null : (DataRow)results.get(0);
        }
        return null;
    }

    public synchronized List getCachedQueryResult(String name) {
        return this.context != null && this.context.queryCache != null ? this.context.queryCache.get(new CacheQueryMetadata(name)) : null;
    }

    public synchronized void cacheQueryResult(String name, List results) {
        if (this.context != null) {
            this.context.getQueryCache().put(new CacheQueryMetadata(name), results);
        }
    }

    public synchronized DataRow getSnapshot(ObjectId oid) {
        if (this.context != null && this.context.getChannel() != null) {
            ObjectIdQuery query = new ObjectIdQuery(oid, true, 1);
            List results = this.context.getChannel().onQuery(this.context, query).firstList();
            return results.isEmpty() ? null : (DataRow)results.get(0);
        }
        return null;
    }

    public synchronized Iterator getObjectIterator() {
        return this.objectMap.values().iterator();
    }

    public synchronized boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    public synchronized List objectsInState(int state) {
        ArrayList<Persistent> filteredObjects = new ArrayList<Persistent>();
        Iterator it = this.objectMap.values().iterator();
        while (it.hasNext()) {
            Persistent nextObj = (Persistent)it.next();
            if (nextObj.getPersistenceState() != state) continue;
            filteredObjects.add(nextObj);
        }
        return filteredObjects;
    }

    public void snapshotsChanged(SnapshotEvent event) {
        if (event.getPostedBy() != this && event.getSource() == this.getDataRowCache()) {
            this.processSnapshotEvent(event);
        }
    }

    synchronized void processSnapshotEvent(SnapshotEvent event) {
        Collection deletedIDs;
        Map modifiedDiffs = event.getModifiedDiffs();
        if (modifiedDiffs != null && !modifiedDiffs.isEmpty()) {
            Iterator oids = modifiedDiffs.entrySet().iterator();
            while (oids.hasNext()) {
                Map.Entry entry = oids.next();
                this.processUpdatedSnapshot(entry.getKey(), (DataRow)entry.getValue());
            }
        }
        if ((deletedIDs = event.getDeletedIds()) != null && !deletedIDs.isEmpty()) {
            Iterator it = deletedIDs.iterator();
            while (it.hasNext()) {
                this.processDeletedID(it.next());
            }
        }
        this.processInvalidatedIDs(event.getInvalidatedIds());
        this.processIndirectlyModifiedIDs(event.getIndirectlyModifiedIds());
        SnapshotEventDecorator diff = new SnapshotEventDecorator(event);
        ObjectContext originatingContext = event.getPostedBy() instanceof ObjectContext ? (ObjectContext)event.getPostedBy() : null;
        this.context.fireDataChannelChanged(originatingContext, diff);
    }

    public void resolveHollow(Persistent object) {
        this.context.prepareForAccess(object, null, false);
    }

    void processIdChange(Object nodeId, Object newId) {
        Persistent object = (Persistent)this.objectMap.remove(nodeId);
        if (object != null) {
            object.setObjectId((ObjectId)newId);
            this.objectMap.put(newId, object);
            Object change = this.changes.remove(nodeId);
            if (change != null) {
                this.changes.put(newId, change);
            }
        }
    }

    void processDeletedID(Object nodeId) {
        Persistent object = (Persistent)this.objectMap.get(nodeId);
        if (object != null) {
            DataObject dataObject = object instanceof DataObject ? (DataObject)object : null;
            switch (object.getPersistenceState()) {
                case 3: 
                case 5: 
                case 6: {
                    DataContextDelegate delegate = this.context.nonNullDelegate();
                    if (dataObject != null && !delegate.shouldProcessDelete(dataObject)) break;
                    this.objectMap.remove(nodeId);
                    this.changes.remove(nodeId);
                    object.setObjectContext(null);
                    if (dataObject == null) break;
                    delegate.finishedProcessDelete(dataObject);
                    break;
                }
                case 4: {
                    DataContextDelegate delegate = this.context.nonNullDelegate();
                    if (dataObject == null || !delegate.shouldProcessDelete(dataObject)) break;
                    object.setPersistenceState(2);
                    this.changes.remove(nodeId);
                    this.registerNode(nodeId, object);
                    this.nodeCreated(nodeId);
                    if (dataObject == null) break;
                    delegate.finishedProcessDelete(dataObject);
                }
            }
        }
    }

    void processInvalidatedIDs(Collection invalidatedIDs) {
        if (invalidatedIDs != null && !invalidatedIDs.isEmpty()) {
            Iterator it = invalidatedIDs.iterator();
            while (it.hasNext()) {
                ObjectId oid = (ObjectId)it.next();
                DataObject object = (DataObject)this.getNode(oid);
                if (object == null) continue;
                switch (object.getPersistenceState()) {
                    case 3: {
                        object.setPersistenceState(5);
                        break;
                    }
                    case 4: {
                        DataContext context = (DataContext)object.getObjectContext();
                        DataRow diff = this.getSnapshot(oid);
                        DataContextDelegate delegate = context.nonNullDelegate();
                        if (delegate.shouldMergeChanges(object, diff)) {
                            ClassDescriptor descriptor = context.getEntityResolver().getClassDescriptor(oid.getEntityName());
                            DataRowUtils.forceMergeWithSnapshot(context, descriptor, object, diff);
                            delegate.finishedMergeChanges(object);
                        }
                    }
                    case 5: {
                        break;
                    }
                }
            }
        }
    }

    void processIndirectlyModifiedIDs(Collection indirectlyModifiedIDs) {
        Iterator indirectlyModifiedIt = indirectlyModifiedIDs.iterator();
        while (indirectlyModifiedIt.hasNext()) {
            DataContextDelegate delegate;
            ObjectId oid = (ObjectId)indirectlyModifiedIt.next();
            final DataObject object = (DataObject)this.objectMap.get(oid);
            if (object == null || object.getPersistenceState() != 3 || !(delegate = this.context.nonNullDelegate()).shouldMergeChanges(object, null)) continue;
            ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(oid.getEntityName());
            descriptor.visitProperties(new PropertyVisitor(){

                public boolean visitToMany(ToManyProperty property) {
                    property.invalidate(object);
                    return true;
                }

                public boolean visitToOne(ToOneProperty property) {
                    if (property.getRelationship().isSourceIndependentFromTargetChange()) {
                        property.invalidate(object);
                    }
                    return true;
                }

                public boolean visitAttribute(AttributeProperty property) {
                    return true;
                }
            });
            delegate.finishedProcessDelete(object);
        }
    }

    void processUpdatedSnapshot(Object nodeId, DataRow diff) {
        int state;
        DataObject object = (DataObject)this.objectMap.get(nodeId);
        if (object != null && (state = object.getPersistenceState()) != 5) {
            DataContextDelegate delegate;
            if (state == 3) {
                DataContextDelegate delegate2 = this.context.nonNullDelegate();
                if (delegate2.shouldMergeChanges(object, diff)) {
                    ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
                    DataRow snapshot = this.getSnapshot(object.getObjectId());
                    DataRowUtils.refreshObjectWithSnapshot(descriptor, object, snapshot, true);
                    delegate2.finishedMergeChanges(object);
                }
            } else if ((state == 6 || state == 4) && (delegate = this.context.nonNullDelegate()).shouldMergeChanges(object, diff)) {
                ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
                DataRowUtils.forceMergeWithSnapshot(this.context, descriptor, object, diff);
                delegate.finishedMergeChanges(object);
            }
        }
    }

    public DataContext getContext() {
        return this.context;
    }

    public void setContext(DataContext context) {
        this.context = context;
    }

    public synchronized Object getNode(Object nodeId) {
        return this.objectMap.get(nodeId);
    }

    final Object getNodeNoSync(Object nodeId) {
        return this.objectMap.get(nodeId);
    }

    public synchronized Collection registeredNodes() {
        return new ArrayList(this.objectMap.values());
    }

    public synchronized void registerNode(Object nodeId, Object nodeObject) {
        this.objectMap.put(nodeId, nodeObject);
    }

    public synchronized Object unregisterNode(Object nodeId) {
        Object object = this.getNode(nodeId);
        if (object != null) {
            this.objectsUnregistered(Collections.singleton(object));
        }
        return object;
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
        throw new UnsupportedOperationException("nodeIdChanged");
    }

    public void nodeCreated(Object nodeId) {
        this.registerDiff(nodeId, new NodeCreateOperation(nodeId));
    }

    public void nodeRemoved(Object nodeId) {
        this.registerDiff(nodeId, new NodeDeleteOperation(nodeId));
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        this.registerDiff(nodeId, null);
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        this.registerDiff(nodeId, new ObjectDiff.ArcOperation(nodeId, targetNodeId, arcId.toString(), false));
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        this.registerDiff(nodeId, new ObjectDiff.ArcOperation(nodeId, targetNodeId, arcId.toString(), true));
    }

    final class CacheQueryMetadata
    implements QueryMetadata {
        private String cacheKey;

        CacheQueryMetadata(String cacheKey) {
            this.cacheKey = cacheKey;
        }

        public String getCacheKey() {
            return this.cacheKey;
        }

        public SQLResultSetMapping getResultSetMapping() {
            return null;
        }

        public String[] getCacheGroups() {
            return null;
        }

        public String getCachePolicy() {
            return null;
        }

        public DataMap getDataMap() {
            return null;
        }

        public DbEntity getDbEntity() {
            return null;
        }

        public int getFetchLimit() {
            return 0;
        }

        public int getFetchStartIndex() {
            return 0;
        }

        public ObjEntity getObjEntity() {
            return null;
        }

        public ClassDescriptor getClassDescriptor() {
            return null;
        }

        public int getPageSize() {
            return 0;
        }

        public PrefetchTreeNode getPrefetchTree() {
            return null;
        }

        public Procedure getProcedure() {
            return null;
        }

        public boolean isFetchingDataRows() {
            return false;
        }

        public boolean isRefreshingObjects() {
            return false;
        }

        public boolean isResolvingInherited() {
            return false;
        }
    }

    class SnapshotEventDecorator
    implements GraphDiff {
        SnapshotEvent event;

        SnapshotEventDecorator(SnapshotEvent event) {
            this.event = event;
        }

        SnapshotEvent getEvent() {
            return this.event;
        }

        public void apply(GraphChangeHandler handler) {
            throw new UnsupportedOperationException();
        }

        public boolean isNoop() {
            throw new UnsupportedOperationException();
        }

        public void undo(GraphChangeHandler handler) {
            throw new UnsupportedOperationException();
        }
    }

    final class CachedSnapshotQuery
    extends ObjectIdQuery {
        CachedSnapshotQuery(ObjectId oid) {
            super(oid, true, 3);
        }

        void resetId(ObjectId oid) {
            this.objectId = oid;
            this.replacementQuery = null;
        }
    }
}

