/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.access.jdbc.EJBQLFromTranslator;
import org.apache.cayenne.access.jdbc.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.parser.EJBQLIdentificationVariable;
import org.apache.cayenne.ejbql.parser.EJBQLIdentifier;
import org.apache.cayenne.ejbql.parser.EJBQLInnerJoin;
import org.apache.cayenne.ejbql.parser.EJBQLPath;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ClassDescriptor;

abstract class EJBQLPathTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    protected ObjEntity currentEntity;
    private String lastPathComponent;
    protected String lastAlias;
    protected String idPath;
    protected String joinMarker;
    private String fullPath;
    private EJBQLFromTranslator joinAppender;

    EJBQLPathTranslator(EJBQLTranslationContext context) {
        super(true);
        this.context = context;
    }

    protected abstract void appendMultiColumnPath(EJBQLMultiColumnOperand var1);

    public boolean visitPath(EJBQLPath expression, int finishedChildIndex) {
        if (finishedChildIndex > 0) {
            if (finishedChildIndex + 1 < expression.getChildrenCount()) {
                this.processIntermediatePathComponent();
            } else {
                this.processLastPathComponent();
            }
        }
        return true;
    }

    public boolean visitIdentifier(EJBQLExpression expression) {
        ClassDescriptor descriptor = this.context.getCompiledExpression().getEntityDescriptor(expression.getText());
        if (descriptor == null) {
            throw new EJBQLException("Invalid identification variable: " + expression.getText());
        }
        this.currentEntity = descriptor.getEntity();
        this.idPath = expression.getText();
        this.joinMarker = EJBQLFromTranslator.makeJoinTailMarker(this.idPath);
        this.fullPath = this.idPath;
        return true;
    }

    public boolean visitIdentificationVariable(EJBQLExpression expression) {
        if (this.lastPathComponent != null) {
            this.resolveJoin();
        }
        this.lastPathComponent = expression.getText();
        return true;
    }

    private EJBQLFromTranslator getJoinAppender() {
        if (this.joinAppender == null) {
            this.joinAppender = new EJBQLFromTranslator(this.context);
        }
        return this.joinAppender;
    }

    private void resolveJoin() {
        String newPath = this.idPath + '.' + this.lastPathComponent;
        String oldPath = this.context.registerReusableJoin(this.idPath, this.lastPathComponent, newPath);
        this.fullPath = this.fullPath + '.' + this.lastPathComponent;
        if (oldPath != null) {
            this.idPath = oldPath;
            this.lastAlias = this.context.getTableAlias(oldPath, this.currentEntity.getDbEntityName());
        } else {
            EJBQLIdentifier id = new EJBQLIdentifier(-1);
            id.setText(this.idPath);
            EJBQLIdentificationVariable idVar = new EJBQLIdentificationVariable(-1);
            idVar.setText(this.lastPathComponent);
            EJBQLPath path = new EJBQLPath(-1);
            path.jjtAddChild(id, 0);
            path.jjtAddChild(idVar, 1);
            EJBQLIdentifier joinId = new EJBQLIdentifier(-1);
            joinId.setText(this.fullPath);
            EJBQLInnerJoin join = new EJBQLInnerJoin(-1);
            join.jjtAddChild(path, 0);
            join.jjtAddChild(joinId, 1);
            this.context.switchToMarker(this.joinMarker);
            this.getJoinAppender().visitInnerJoin(join);
            this.context.switchToMainBuffer();
            this.idPath = newPath;
            this.lastAlias = this.context.getTableAlias(this.fullPath, this.currentEntity.getDbEntityName());
        }
    }

    private void processIntermediatePathComponent() {
        ObjRelationship relationship = (ObjRelationship)this.currentEntity.getRelationship(this.lastPathComponent);
        if (relationship == null) {
            throw new EJBQLException("Unknown relationship '" + this.lastPathComponent + "' for entity '" + this.currentEntity.getName() + "'");
        }
        this.currentEntity = (ObjEntity)relationship.getTargetEntity();
    }

    private void processLastPathComponent() {
        ObjAttribute attribute = (ObjAttribute)this.currentEntity.getAttribute(this.lastPathComponent);
        if (attribute != null) {
            this.processTerminatingAttribute(attribute);
            return;
        }
        ObjRelationship relationship = (ObjRelationship)this.currentEntity.getRelationship(this.lastPathComponent);
        if (relationship != null) {
            this.processTerminatingRelationship(relationship);
            return;
        }
        throw new IllegalStateException("Invalid path component: " + this.lastPathComponent);
    }

    protected void processTerminatingAttribute(ObjAttribute attribute) {
        DbEntity table = this.currentEntity.getDbEntity();
        String alias = this.lastAlias != null ? this.lastAlias : this.context.getTableAlias(this.idPath, table.getFullyQualifiedName());
        this.context.append(' ').append(alias).append('.').append(attribute.getDbAttributeName());
    }

    private void processTerminatingRelationship(ObjRelationship relationship) {
        if (!relationship.isSourceIndependentFromTargetChange()) {
            DbRelationship dbRelationship = (DbRelationship)relationship.getDbRelationships().get(0);
            DbEntity table = (DbEntity)dbRelationship.getSourceEntity();
            String alias = this.lastAlias != null ? this.lastAlias : this.context.getTableAlias(this.idPath, table.getFullyQualifiedName());
            List joins = dbRelationship.getJoins();
            if (joins.size() == 1) {
                DbJoin join = (DbJoin)joins.get(0);
                this.context.append(' ').append(alias).append('.').append(join.getSourceName());
            } else {
                HashMap<String, String> multiColumnMatch = new HashMap<String, String>(joins.size() + 2);
                Iterator it = joins.iterator();
                while (it.hasNext()) {
                    DbJoin join = (DbJoin)it.next();
                    String column = alias + "." + join.getSourceName();
                    multiColumnMatch.put(join.getTargetName(), column);
                }
                this.appendMultiColumnPath(EJBQLMultiColumnOperand.getPathOperand(this.context, multiColumnMatch));
            }
        }
    }
}

