/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.trans.QueryAssemblerHelper;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;

public class OrderingTranslator
extends QueryAssemblerHelper {
    protected List orderByColumnList = new ArrayList();

    public OrderingTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    public String doTranslation() {
        Query q = this.queryAssembler.getQuery();
        if (q == null || !(q instanceof SelectQuery)) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        List list = ((SelectQuery)q).getOrderings();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            Expression exp;
            if (i > 0) {
                buf.append(", ");
            }
            StringBuffer ordComp = new StringBuffer();
            Ordering ord = (Ordering)list.get(i);
            if (ord.isCaseInsensitive()) {
                ordComp.append("UPPER(");
            }
            if ((exp = ord.getSortSpec()).getType() == 26) {
                this.appendObjPath(ordComp, exp);
            } else if (exp.getType() == 27) {
                this.appendDbPath(ordComp, exp);
            } else {
                throw new CayenneRuntimeException("Unsupported ordering expression: " + exp);
            }
            if (ord.isCaseInsensitive()) {
                ordComp.append(")");
            }
            this.orderByColumnList.add(ordComp.toString());
            buf.append(ordComp.toString());
            if (ord.isAscending()) continue;
            buf.append(" DESC");
        }
        return buf.length() > 0 ? buf.toString() : null;
    }

    public List getOrderByColumnList() {
        return this.orderByColumnList;
    }
}

