/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.access.types.ByteOrCharArrayFactory;
import org.apache.cayenne.access.types.DefaultType;
import org.apache.cayenne.access.types.EnumTypeFactory;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.SerializableTypeFactory;
import org.apache.cayenne.access.types.SubclassTypeFactory;
import org.apache.cayenne.access.types.VoidType;
import org.apache.cayenne.util.Util;

public class ExtendedTypeMap {
    protected Map typeMap = new HashMap();
    protected DefaultType defaultType = new DefaultType();
    Collection extendedTypeFactories;
    Collection internalTypeFactories;

    public ExtendedTypeMap() {
        this.initDefaultTypes();
        this.initDefaultFactories();
    }

    protected void initDefaultTypes() {
        this.registerType(new VoidType());
        Iterator it = DefaultType.defaultTypes();
        while (it.hasNext()) {
            this.registerType(new DefaultType((String)it.next()));
        }
    }

    protected void initDefaultFactories() {
        this.internalTypeFactories = new ArrayList(3);
        this.internalTypeFactories.add(new EnumTypeFactory());
        this.internalTypeFactories.add(new ByteOrCharArrayFactory(this));
        this.internalTypeFactories.add(new SerializableTypeFactory(this));
    }

    public Collection getFactories() {
        return this.extendedTypeFactories != null ? Collections.unmodifiableCollection(this.extendedTypeFactories) : Collections.EMPTY_SET;
    }

    public void addFactory(ExtendedTypeFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Attempt to add null factory");
        }
        if (this.extendedTypeFactories == null) {
            this.extendedTypeFactories = new ArrayList();
        }
        this.extendedTypeFactories.add(factory);
    }

    public void removeFactory(ExtendedTypeFactory factory) {
        if (factory != null && this.extendedTypeFactories != null && this.extendedTypeFactories.remove(factory) && this.extendedTypeFactories.isEmpty()) {
            this.extendedTypeFactories = null;
        }
    }

    public void registerType(ExtendedType type) {
        this.typeMap.put(type.getClassName(), type);
        this.addFactory(new SubclassTypeFactory(type));
    }

    public ExtendedType getDefaultType() {
        return this.defaultType;
    }

    public ExtendedType getRegisteredType(String javaClassName) {
        ExtendedType type = this.getExplictlyRegisteredType(javaClassName);
        if (type != null) {
            return type;
        }
        type = this.getDefaultType(javaClassName);
        if (type != null) {
            this.registerType(type);
            return type;
        }
        return this.getDefaultType();
    }

    ExtendedType getExplictlyRegisteredType(String className) {
        return (ExtendedType)this.typeMap.get(className);
    }

    public ExtendedType getRegisteredType(Class javaClass) {
        String name = null;
        name = javaClass.isArray() ? javaClass.getComponentType().getName() + "[]" : javaClass.getName();
        return this.getRegisteredType(name);
    }

    public void unregisterType(String javaClassName) {
        this.typeMap.remove(javaClassName);
    }

    public String[] getRegisteredTypeNames() {
        Set keys = this.typeMap.keySet();
        int len = keys.size();
        String[] types = new String[len];
        Iterator it = keys.iterator();
        for (int i = 0; i < len; ++i) {
            types[i] = (String)it.next();
        }
        return types;
    }

    protected ExtendedType getDefaultType(String javaClassName) {
        return this.createType(javaClassName);
    }

    protected ExtendedType createType(String className) {
        ExtendedType type;
        ExtendedTypeFactory factory;
        Iterator it;
        Class typeClass;
        if (className == null) {
            return null;
        }
        try {
            typeClass = Util.getJavaClass(className);
        }
        catch (Throwable th) {
            return null;
        }
        if (this.extendedTypeFactories != null) {
            it = this.extendedTypeFactories.iterator();
            while (it.hasNext()) {
                factory = (ExtendedTypeFactory)it.next();
                type = factory.getType(typeClass);
                if (type == null) continue;
                return type;
            }
        }
        it = this.internalTypeFactories.iterator();
        while (it.hasNext()) {
            factory = (ExtendedTypeFactory)it.next();
            type = factory.getType(typeClass);
            if (type == null) continue;
            return type;
        }
        return null;
    }
}

