/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.apache.cayenne.conf.ConfigSaverDelegate;
import org.apache.cayenne.conf.PasswordEncoding;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.util.Util;

public class ConfigSaver {
    protected ConfigSaverDelegate delegate;

    public ConfigSaver() {
    }

    public ConfigSaver(ConfigSaverDelegate delegate) {
        this.delegate = delegate;
    }

    public void storeDomains(PrintWriter pw) {
        pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        pw.println("<domains project-version=\"" + this.delegate.projectVersion() + "\">");
        Iterator it = this.delegate.domainNames();
        while (it.hasNext()) {
            this.storeDomain(pw, (String)it.next());
        }
        Iterator views = this.delegate.viewNames();
        while (views.hasNext()) {
            this.storeDataView(pw, (String)views.next());
        }
        pw.println("</domains>");
    }

    protected void storeDataView(PrintWriter pw, String dataViewName) {
        String location = this.delegate.viewLocation(dataViewName);
        pw.print("<view name=\"" + dataViewName.trim());
        pw.print("\" location=\"" + location.trim());
        pw.println("\"/>");
    }

    protected void storeDomain(PrintWriter pw, String domainName) {
        pw.println("<domain name=\"" + domainName.trim() + "\">");
        Iterator properties = this.delegate.propertyNames(domainName);
        boolean breakNeeded = properties.hasNext();
        while (properties.hasNext()) {
            String value;
            String name = (String)properties.next();
            if (name == null || (value = this.delegate.propertyValue(domainName, name)) == null) continue;
            pw.print("\t<property name=\"" + Util.encodeXmlAttribute(name.trim()));
            pw.println("\" value=\"" + Util.encodeXmlAttribute(value.trim()) + "\"/>");
        }
        Iterator maps = this.delegate.mapNames(domainName);
        if (maps.hasNext()) {
            if (breakNeeded) {
                pw.println();
            }
            breakNeeded = true;
        }
        while (maps.hasNext()) {
            String mapName = (String)maps.next();
            String mapLocation = this.delegate.mapLocation(domainName, mapName);
            pw.print("\t<map name=\"" + mapName.trim());
            pw.print("\" location=\"" + mapLocation.trim());
            pw.println("\"/>");
        }
        Iterator nodes = this.delegate.nodeNames(domainName);
        if (nodes.hasNext() && breakNeeded) {
            pw.println();
        }
        while (nodes.hasNext()) {
            String nodeName = (String)nodes.next();
            String datasource = this.delegate.nodeDataSourceName(domainName, nodeName);
            String adapter = this.delegate.nodeAdapterName(domainName, nodeName);
            String factory = this.delegate.nodeFactoryName(domainName, nodeName);
            Iterator mapNames = this.delegate.linkedMapNames(domainName, nodeName);
            pw.println("\t<node name=\"" + nodeName.trim() + "\"");
            if (datasource != null) {
                datasource = datasource.trim();
                pw.print("\t\t datasource=\"" + datasource + "\"");
            }
            pw.println("");
            if (adapter != null) {
                pw.println("\t\t adapter=\"" + adapter + "\"");
            }
            if (factory != null) {
                pw.print("\t\t factory=\"" + factory.trim() + "\"");
            }
            pw.println(">");
            while (mapNames.hasNext()) {
                String mapName = (String)mapNames.next();
                pw.println("\t\t\t<map-ref name=\"" + mapName.trim() + "\"/>");
            }
            pw.println("\t </node>");
        }
        pw.println("</domain>");
    }

    private String attribute(String key, String value) {
        if (value != null) {
            return " " + key + "=\"" + Util.encodeXmlAttribute(value) + "\"";
        }
        return "";
    }

    public void storeDataNode(PrintWriter pw, Project project, DataSourceInfo info) {
        pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        pw.println("<driver" + this.attribute("project-version", "2.0") + this.attribute("class", info.getJdbcDriver()) + ">");
        if (info.getDataSourceUrl() != null) {
            pw.println("\t<url" + this.attribute("value", info.getDataSourceUrl()) + "/>");
        }
        pw.println("\t<connectionPool" + this.attribute("min", String.valueOf(info.getMinConnections())) + this.attribute("max", String.valueOf(info.getMaxConnections())) + "/>");
        pw.print("\t<login");
        if (info.getUserName() != null) {
            pw.print(this.attribute("userName", info.getUserName()));
        }
        if (info.getPasswordLocation().equals("model")) {
            PasswordEncoding encoder = info.getPasswordEncoder();
            if (encoder != null) {
                pw.print(this.attribute("password", encoder.encodePassword(info.getPassword(), info.getPasswordEncoderSalt())));
            }
        } else if (info.getPasswordLocation().equals("classpath") && info.getPasswordSource() != null) {
            File passwordFile = new File(project.getProjectDirectory() + File.separator + info.getPasswordSource());
            PasswordEncoding encoder = info.getPasswordEncoder();
            if (encoder != null && passwordFile != null) {
                try {
                    PrintStream out = new PrintStream(new FileOutputStream(passwordFile));
                    out.print(encoder.encodePassword(info.getPassword(), info.getPasswordEncoderSalt()));
                    out.close();
                }
                catch (FileNotFoundException exception) {
                    exception.printStackTrace();
                }
            }
        }
        pw.println(this.attribute("encoderClass", info.getPasswordEncoderClass()) + this.attribute("encoderSalt", info.getPasswordEncoderSalt()) + this.attribute("passwordLocation", info.getPasswordLocation()) + this.attribute("passwordSource", info.getPasswordSource()) + "/>");
        pw.println("</driver>");
    }
}

