/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dataview;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.cayenne.dataview.MapFormat;

public class FormatFactory {
    private Map builders = new HashMap();

    public FormatFactory() {
        this.registerBuilder(DecimalFormat.class, new DecimalFormatBuilder());
        this.registerBuilder(NumberFormat.class, new DecimalFormatBuilder());
        this.registerBuilder(SimpleDateFormat.class, new SimpleDateFormatBuilder());
        this.registerBuilder(DateFormat.class, new SimpleDateFormatBuilder());
        this.registerBuilder(ChoiceFormat.class, new ChoiceFormatBuilder());
        this.registerBuilder(MessageFormat.class, new MessageFormatBuilder());
        this.registerBuilder(MapFormat.class, new MapFormatBuilder());
    }

    public Format createFormat(Class formatClass, Locale locale, Map parameters) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Builder builder = this.getBuilder(formatClass);
        Format format = builder.create(locale, parameters);
        return format;
    }

    public Builder registerBuilder(Class formatClass, Builder builder) {
        return this.builders.put(formatClass, builder);
    }

    public Builder unregisterBuilder(Class formatClass) {
        return (Builder)this.builders.remove(formatClass);
    }

    public Builder getBuilder(Class formatClass) {
        return (Builder)this.builders.get(formatClass);
    }

    public static class MapFormatBuilder
    implements Builder {
        public Format create(Locale locale, Map parameters) {
            MapFormat format = new MapFormat();
            String pattern = (String)parameters.get("pattern");
            String valueClassName = (String)parameters.get("value-class");
            String nullValueDesignation = (String)parameters.get("null-value");
            String entryDelimiter = (String)parameters.get("entry-delimiter");
            String valueFormatDelimiter = (String)parameters.get("value-delimiter");
            if (entryDelimiter != null && entryDelimiter.length() > 0) {
                format.setEntryDelimiter(entryDelimiter.charAt(0));
            }
            if (valueFormatDelimiter != null && valueFormatDelimiter.length() > 0) {
                format.setValueFormatDelimiter(valueFormatDelimiter.charAt(0));
            }
            if (nullValueDesignation != null) {
                format.setNullValueDesignation(nullValueDesignation);
            }
            try {
                Class<?> valueClass = Class.forName(valueClassName);
                format.applyPattern(pattern, valueClass);
                return format;
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Value class " + valueClassName + " not found");
            }
        }
    }

    public static class MessageFormatBuilder
    implements Builder {
        public Format create(Locale locale, Map parameters) {
            String pattern = (String)parameters.get("pattern");
            MessageFormat format = new MessageFormat(pattern, locale);
            return format;
        }
    }

    public static class ChoiceFormatBuilder
    implements Builder {
        public Format create(Locale locale, Map parameters) {
            String pattern = (String)parameters.get("pattern");
            ChoiceFormat format = new ChoiceFormat(pattern);
            return format;
        }
    }

    public static class SimpleDateFormatBuilder
    implements Builder {
        public Format create(Locale locale, Map parameters) {
            String pattern = (String)parameters.get("pattern");
            DateFormatSymbols sym = new DateFormatSymbols(locale);
            SimpleDateFormat format = new SimpleDateFormat();
            format.setDateFormatSymbols(sym);
            if (pattern != null) {
                format.applyPattern(pattern);
            }
            return format;
        }
    }

    public static class DecimalFormatBuilder
    implements Builder {
        public Format create(Locale locale, Map parameters) {
            String pattern = (String)parameters.get("pattern");
            DecimalFormatSymbols sym = new DecimalFormatSymbols(locale);
            DecimalFormat format = new DecimalFormat();
            format.setDecimalFormatSymbols(sym);
            if (pattern != null) {
                format.applyPattern(pattern);
            }
            return format;
        }
    }

    public static interface Builder {
        public Format create(Locale var1, Map var2);
    }
}

