/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.util.Invocation;

class DispatchQueue {
    private Set subjectInvocations = new HashSet();
    private Map invocationsBySender = new WeakHashMap();

    DispatchQueue() {
    }

    synchronized void dispatchEvent(EventManager.Dispatch dispatch) {
        this.dispatchEvent(this.subjectInvocations, dispatch);
        Object sender = dispatch.getSender();
        this.dispatchEvent(this.invocationsForSender(sender, false), dispatch);
    }

    synchronized void addInvocation(Invocation invocation, Object sender) {
        if (sender == null) {
            this.subjectInvocations.add(invocation);
        } else {
            this.invocationsForSender(sender, true).add(invocation);
        }
    }

    synchronized boolean removeInvocations(Object listener, Object sender) {
        if (sender != null) {
            return this.removeInvocations(this.invocationsForSender(sender, false), listener);
        }
        boolean didRemove = false;
        didRemove = this.removeInvocations(this.subjectInvocations, listener);
        Iterator sets = this.invocationsBySender.values().iterator();
        while (sets.hasNext()) {
            Collection senderInvocations = (Collection)sets.next();
            if (senderInvocations == null) continue;
            Iterator it = senderInvocations.iterator();
            while (it.hasNext()) {
                Invocation invocation = (Invocation)it.next();
                if (invocation.getTarget() != listener) continue;
                it.remove();
                didRemove = true;
            }
        }
        return didRemove;
    }

    private Collection invocationsForSender(Object sender, boolean create) {
        HashSet senderInvocations = (HashSet)this.invocationsBySender.get(sender);
        if (create && senderInvocations == null) {
            senderInvocations = new HashSet();
            this.invocationsBySender.put(sender, senderInvocations);
        }
        return senderInvocations;
    }

    private boolean removeInvocations(Collection invocations, Object listener) {
        if (invocations == null || invocations.isEmpty()) {
            return false;
        }
        boolean didRemove = false;
        Iterator invocationsIt = invocations.iterator();
        while (invocationsIt.hasNext()) {
            Invocation invocation = (Invocation)invocationsIt.next();
            if (invocation.getTarget() != listener) continue;
            invocationsIt.remove();
            didRemove = true;
        }
        return didRemove;
    }

    private void dispatchEvent(Collection invocations, EventManager.Dispatch dispatch) {
        if (invocations == null || invocations.isEmpty()) {
            return;
        }
        Iterator it = new ArrayList(invocations).iterator();
        while (it.hasNext()) {
            Invocation invocation = (Invocation)it.next();
            if (dispatch.fire(invocation)) continue;
            invocations.remove(invocation);
        }
    }
}

