/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.intercept;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.intercept.ObjectContextDecorator;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;

public class ObjectContextCallbackInterceptor
extends ObjectContextDecorator {
    protected LifecycleCallbackRegistry callbackRegistry;

    public void setContext(ObjectContext context) {
        super.setContext(context);
        this.callbackRegistry = context != null ? context.getEntityResolver().getCallbackRegistry() : null;
    }

    public Persistent newObject(Class persistentClass) {
        Persistent object = super.newObject(persistentClass);
        this.callbackRegistry.performCallbacks(0, object);
        return object;
    }

    public void registerNewObject(Object object) {
        super.registerNewObject(object);
        this.callbackRegistry.performCallbacks(0, object);
    }

    public void deleteObject(Persistent object) throws DeleteDenyException {
        this.applyPreRemoveCallbacks(object);
        super.deleteObject(object);
    }

    void applyPreRemoveCallbacks(Persistent object) {
        if (object.getPersistenceState() != 2) {
            this.callbackRegistry.performCallbacks(1, object);
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(object);
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        Iterator it = entity.getRelationships().iterator();
        while (it.hasNext()) {
            Object related;
            ObjRelationship relationship = (ObjRelationship)it.next();
            if (relationship.getDeleteRule() != 2 || (related = descriptor.getProperty(relationship.getName()).readProperty(object)) == null) continue;
            if (related instanceof Collection) {
                Iterator relatedObjects = ((Collection)related).iterator();
                while (relatedObjects.hasNext()) {
                    this.applyPreRemoveCallbacks((Persistent)relatedObjects.next());
                }
                continue;
            }
            this.applyPreRemoveCallbacks((Persistent)related);
        }
    }
}

