/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.jpa.map.AccessType;
import org.apache.cayenne.jpa.map.JpaClassDescriptor;
import org.apache.cayenne.jpa.map.JpaEmbeddable;
import org.apache.cayenne.jpa.map.JpaEntity;
import org.apache.cayenne.jpa.map.JpaMappedSuperclass;
import org.apache.cayenne.jpa.map.JpaNamedNativeQuery;
import org.apache.cayenne.jpa.map.JpaNamedQuery;
import org.apache.cayenne.jpa.map.JpaPersistenceUnitMetadata;
import org.apache.cayenne.jpa.map.JpaSequenceGenerator;
import org.apache.cayenne.jpa.map.JpaSqlResultSetMapping;
import org.apache.cayenne.jpa.map.JpaTableGenerator;
import org.apache.cayenne.util.TreeNodeChild;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaEntityMap {
    protected String version;
    protected String description;
    protected String packageName;
    protected String catalog;
    protected String schema;
    protected AccessType access;
    protected JpaPersistenceUnitMetadata persistenceUnitMetadata;
    protected Collection<JpaEntity> entities;
    protected Collection<JpaEmbeddable> embeddables;
    protected Collection<JpaMappedSuperclass> mappedSuperclasses;
    protected Collection<JpaNamedQuery> namedQueries;
    protected Collection<JpaNamedNativeQuery> namedNativeQueries;
    protected Collection<JpaSqlResultSetMapping> sqlResultSetMappings;
    protected Collection<JpaSequenceGenerator> sequenceGenerators;
    protected Collection<JpaTableGenerator> tableGenerators;

    public boolean containsManagedClass(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (this.mappedSuperclasses != null) {
            for (JpaMappedSuperclass jpaMappedSuperclass : this.mappedSuperclasses) {
                if (!className.equals(jpaMappedSuperclass.getClassName())) continue;
                return true;
            }
        }
        if (this.entities != null) {
            for (JpaEntity jpaEntity : this.entities) {
                if (!className.equals(jpaEntity.getClassName())) continue;
                return true;
            }
        }
        if (this.embeddables != null) {
            for (JpaEmbeddable jpaEmbeddable : this.embeddables) {
                if (!className.equals(jpaEmbeddable.getClassName())) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, JpaClassDescriptor> getMangedClasses() {
        HashMap<String, JpaClassDescriptor> managedClasses = new HashMap<String, JpaClassDescriptor>();
        if (this.mappedSuperclasses != null) {
            for (JpaMappedSuperclass jpaMappedSuperclass : this.mappedSuperclasses) {
                managedClasses.put(jpaMappedSuperclass.getClassName(), jpaMappedSuperclass.getClassDescriptor());
            }
        }
        if (this.entities != null) {
            for (JpaEntity jpaEntity : this.entities) {
                managedClasses.put(jpaEntity.getClassName(), jpaEntity.getClassDescriptor());
            }
        }
        if (this.embeddables != null) {
            for (JpaEmbeddable jpaEmbeddable : this.embeddables) {
                managedClasses.put(jpaEmbeddable.getClassName(), jpaEmbeddable.getClassDescriptor());
            }
        }
        return managedClasses;
    }

    public JpaEntity entityForClass(Class entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("Null entity class");
        }
        return this.entityForClass(entityClass.getName());
    }

    public JpaEntity entityForClass(String entityClassName) {
        if (entityClassName == null) {
            throw new IllegalArgumentException("Null entity class name");
        }
        for (JpaEntity entity : this.entities) {
            if (!entityClassName.equals(entity.getClassName())) continue;
            return entity;
        }
        return null;
    }

    public AccessType getAccess() {
        return this.access;
    }

    public void setAccess(AccessType access) {
        this.access = access;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageProperty) {
        this.packageName = packageProperty;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @TreeNodeChild(type=JpaEmbeddable.class)
    public Collection<JpaEmbeddable> getEmbeddables() {
        if (this.embeddables == null) {
            this.embeddables = new ArrayList<JpaEmbeddable>();
        }
        return this.embeddables;
    }

    @TreeNodeChild(type=JpaEntity.class)
    public Collection<JpaEntity> getEntities() {
        if (this.entities == null) {
            this.entities = new ArrayList<JpaEntity>();
        }
        return this.entities;
    }

    @TreeNodeChild(type=JpaMappedSuperclass.class)
    public Collection<JpaMappedSuperclass> getMappedSuperclasses() {
        if (this.mappedSuperclasses == null) {
            this.mappedSuperclasses = new ArrayList<JpaMappedSuperclass>();
        }
        return this.mappedSuperclasses;
    }

    @TreeNodeChild(type=JpaNamedNativeQuery.class)
    public Collection<JpaNamedNativeQuery> getNamedNativeQueries() {
        if (this.namedNativeQueries == null) {
            this.namedNativeQueries = new ArrayList<JpaNamedNativeQuery>();
        }
        return this.namedNativeQueries;
    }

    @TreeNodeChild(type=JpaNamedQuery.class)
    public Collection<JpaNamedQuery> getNamedQueries() {
        if (this.namedQueries == null) {
            this.namedQueries = new ArrayList<JpaNamedQuery>();
        }
        return this.namedQueries;
    }

    @TreeNodeChild(type=JpaSequenceGenerator.class)
    public Collection<JpaSequenceGenerator> getSequenceGenerators() {
        if (this.sequenceGenerators == null) {
            this.sequenceGenerators = new ArrayList<JpaSequenceGenerator>();
        }
        return this.sequenceGenerators;
    }

    @TreeNodeChild(type=JpaSqlResultSetMapping.class)
    public Collection<JpaSqlResultSetMapping> getSqlResultSetMappings() {
        if (this.sqlResultSetMappings == null) {
            this.sqlResultSetMappings = new ArrayList<JpaSqlResultSetMapping>();
        }
        return this.sqlResultSetMappings;
    }

    @TreeNodeChild(type=JpaTableGenerator.class)
    public Collection<JpaTableGenerator> getTableGenerators() {
        if (this.tableGenerators == null) {
            this.tableGenerators = new ArrayList<JpaTableGenerator>();
        }
        return this.tableGenerators;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @TreeNodeChild
    public JpaPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.persistenceUnitMetadata;
    }

    public void setPersistenceUnitMetadata(JpaPersistenceUnitMetadata persistenceUnitMetadata) {
        this.persistenceUnitMetadata = persistenceUnitMetadata;
    }
}

