/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.cayenne.jpa.JpaProviderException;
import org.apache.cayenne.jpa.map.JpaClassDescriptor;

public class JpaPropertyDescriptor {
    protected AnnotatedElement member;
    protected String name;
    protected Class type;
    protected Type genericType;
    protected Class targetEntityType;

    public JpaPropertyDescriptor(Field field) {
        this.member = field;
        this.name = field.getName();
        this.type = field.getType();
        this.genericType = field.getGenericType();
    }

    public JpaPropertyDescriptor(Method getter, String name) {
        if (JpaClassDescriptor.propertyNameForGetter(getter.getName()) == null) {
            throw new JpaProviderException("Invalid property getter name: " + getter.getName());
        }
        this.member = getter;
        this.name = name;
        this.type = getter.getReturnType();
        this.genericType = getter.getGenericReturnType();
    }

    protected void processTargetEntityType() {
        this.targetEntityType = Void.TYPE;
        if (Collection.class.isAssignableFrom(this.type)) {
            if (this.genericType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)this.genericType;
                Type[] bounds = pType.getActualTypeArguments();
                for (int i = bounds.length - 1; i >= 0; --i) {
                    if (!(bounds[i] instanceof Class)) continue;
                    this.targetEntityType = (Class)bounds[i];
                    return;
                }
            }
        } else {
            this.targetEntityType = this.type;
        }
    }

    public AnnotatedElement getMember() {
        return this.member;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public Class getTargetEntityType() {
        if (this.targetEntityType == null) {
            this.processTargetEntityType();
        }
        return Void.TYPE.equals(this.targetEntityType) ? null : this.targetEntityType;
    }

    public boolean isStringType() {
        return String.class.isAssignableFrom(this.type);
    }

    public boolean isDefaultNonRelationalType() {
        return this.isDefaultNonRelationalType(this.getTargetEntityType());
    }

    boolean isDefaultNonRelationalType(Class type) {
        if (type.isPrimitive() || type.isEnum()) {
            return true;
        }
        if (type.isArray()) {
            return this.isDefaultNonRelationalType(type.getComponentType());
        }
        return Serializable.class.isAssignableFrom(type);
    }
}

