/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class Embeddable
implements XMLSerializable,
Serializable {
    protected String className;
    protected SortedMap attributes = new TreeMap();

    public Embeddable() {
        this(null);
    }

    public Embeddable(String className) {
        this.className = className;
    }

    public EmbeddableAttribute getAttributeForDbPath(String dbPath) {
        Iterator it = this.attributes.values().iterator();
        while (it.hasNext()) {
            EmbeddableAttribute attribute = (EmbeddableAttribute)it.next();
            if (!dbPath.equals(attribute.getDbAttributeName())) continue;
            return attribute;
        }
        return null;
    }

    public SortedMap getAttributeMap() {
        return Collections.unmodifiableSortedMap(this.attributes);
    }

    public Collection getAttributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    public void addAttribute(EmbeddableAttribute attribute) {
        if (attribute.getName() == null) {
            throw new IllegalArgumentException("Attempt to insert unnamed attribute.");
        }
        Object existingAttribute = this.attributes.get(attribute.getName());
        if (existingAttribute != null) {
            if (existingAttribute == attribute) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override embeddable attribute '" + attribute.getName() + "'");
        }
        this.attributes.put(attribute.getName(), attribute);
        attribute.setEmbeddable(this);
    }

    public EmbeddableAttribute getAttribute(String name) {
        return (EmbeddableAttribute)this.attributes.get(name);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<embeddable");
        if (this.getClassName() != null) {
            encoder.print(" className=\"");
            encoder.print(this.getClassName());
            encoder.print("\"");
        }
        encoder.println(">");
        encoder.indent(1);
        encoder.print(this.attributes);
        encoder.indent(-1);
        encoder.println("</embeddable>");
    }
}

