/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.util.Collection;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.project.ProjectException;

abstract class ApplicationUpgradeHandler {
    private static final ApplicationUpgradeHandler sharedInstance = new UpgradeHandler_2_0();

    ApplicationUpgradeHandler() {
    }

    static ApplicationUpgradeHandler sharedHandler() {
        return sharedInstance;
    }

    abstract String supportedVersion();

    abstract int checkForUpgrades(Configuration var1, Collection var2);

    abstract void performUpgrade(ApplicationProject var1) throws ProjectException;

    int compareVersion(String version) {
        double newVersion;
        double supported = ApplicationUpgradeHandler.decodeVersion(this.supportedVersion());
        return supported < (newVersion = ApplicationUpgradeHandler.decodeVersion(version)) ? -1 : (supported == newVersion ? 0 : 1);
    }

    static double decodeVersion(String version) {
        if (version == null || version.trim().length() == 0) {
            return 0.0;
        }
        StringBuffer buffer = new StringBuffer(version.length());
        boolean dotProcessed = false;
        for (int i = 0; i < version.length(); ++i) {
            char nextChar = version.charAt(i);
            if (nextChar == '.' && !dotProcessed) {
                dotProcessed = true;
                buffer.append('.');
                continue;
            }
            if (!Character.isDigit(nextChar)) continue;
            buffer.append(nextChar);
        }
        return Double.parseDouble(buffer.toString());
    }

    static class UpgradeHandler_1_1
    extends ApplicationUpgradeHandler {
        UpgradeHandler_1_1() {
        }

        String supportedVersion() {
            return "1.1";
        }

        void performUpgrade(ApplicationProject project) throws ProjectException {
            project.setModified(true);
            project.getConfiguration().setProjectVersion(this.supportedVersion());
            project.save();
        }

        int checkForUpgrades(Configuration project, Collection appendMessages) {
            String loadedVersion = project.getProjectVersion();
            int versionState = this.compareVersion(loadedVersion);
            if (versionState < 0) {
                String versionLabel = loadedVersion != null ? loadedVersion : "?";
                appendMessages.add("Newer Project Version Detected: \"" + versionLabel + "\"");
                return 1;
            }
            if (versionState > 0) {
                String versionLabel = loadedVersion != null ? loadedVersion : "?";
                appendMessages.add("Older Project Version Detected: \"" + versionLabel + "\"");
                return -1;
            }
            return 0;
        }
    }

    static class UpgradeHandler_2_0
    extends UpgradeHandler_1_1 {
        static final String _1_2_PACKAGE_PREFIX = "org.objectstyle.cayenne.";
        static final String _2_0_PACKAGE_PREFIX = "org.apache.cayenne.";

        UpgradeHandler_2_0() {
        }

        String supportedVersion() {
            return "2.0";
        }
    }
}

